/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.endpoint;

import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.source.All;
import org.apache.skywalking.oap.server.core.source.DatabaseAccess;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.Endpoint;
import org.apache.skywalking.oap.server.core.source.EndpointRelation;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.Service;
import org.apache.skywalking.oap.server.core.source.ServiceInstance;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceRelation;
import org.apache.skywalking.oap.server.core.source.ServiceRelation;

class SourceBuilder {
    private int sourceServiceId;
    private String sourceServiceName;
    private int sourceServiceInstanceId;
    private String sourceServiceInstanceName;
    private int sourceEndpointId;
    private String sourceEndpointName;
    private int destServiceId;
    private String destServiceName;
    private int destServiceInstanceId;
    private String destServiceInstanceName;
    private int destEndpointId;
    private String destEndpointName;
    private int componentId;
    private int latency;
    private boolean status;
    private int responseCode;
    private RequestType type;
    private DetectPoint detectPoint;
    private long timeBucket;

    SourceBuilder() {
    }

    All toAll() {
        All all = new All();
        all.setName(this.destServiceName);
        all.setServiceInstanceName(this.destServiceInstanceName);
        all.setEndpointName(this.destEndpointName);
        all.setLatency(this.latency);
        all.setStatus(this.status);
        all.setResponseCode(this.responseCode);
        all.setType(this.type);
        all.setTimeBucket(this.timeBucket);
        return all;
    }

    Service toService() {
        Service service = new Service();
        service.setId(this.destServiceId);
        service.setName(this.destServiceName);
        service.setServiceInstanceName(this.destServiceInstanceName);
        service.setEndpointName(this.destEndpointName);
        service.setLatency(this.latency);
        service.setStatus(this.status);
        service.setResponseCode(this.responseCode);
        service.setType(this.type);
        service.setTimeBucket(this.timeBucket);
        return service;
    }

    ServiceRelation toServiceRelation() {
        ServiceRelation serviceRelation = new ServiceRelation();
        serviceRelation.setSourceServiceId(this.sourceServiceId);
        serviceRelation.setSourceServiceName(this.sourceServiceName);
        serviceRelation.setSourceServiceInstanceName(this.sourceServiceInstanceName);
        serviceRelation.setDestServiceId(this.destServiceId);
        serviceRelation.setDestServiceName(this.destServiceName);
        serviceRelation.setDestServiceInstanceName(this.destServiceInstanceName);
        serviceRelation.setEndpoint(this.destEndpointName);
        serviceRelation.setComponentId(this.componentId);
        serviceRelation.setLatency(this.latency);
        serviceRelation.setStatus(this.status);
        serviceRelation.setResponseCode(this.responseCode);
        serviceRelation.setType(this.type);
        serviceRelation.setDetectPoint(this.detectPoint);
        serviceRelation.setTimeBucket(this.timeBucket);
        return serviceRelation;
    }

    ServiceInstance toServiceInstance() {
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setId(this.destServiceInstanceId);
        serviceInstance.setServiceId(this.destServiceId);
        serviceInstance.setName(this.destServiceInstanceName);
        serviceInstance.setServiceName(this.destServiceName);
        serviceInstance.setEndpointName(this.destEndpointName);
        serviceInstance.setLatency(this.latency);
        serviceInstance.setStatus(this.status);
        serviceInstance.setResponseCode(this.responseCode);
        serviceInstance.setType(this.type);
        serviceInstance.setTimeBucket(this.timeBucket);
        return serviceInstance;
    }

    ServiceInstanceRelation toServiceInstanceRelation() {
        ServiceInstanceRelation serviceInstanceRelation = new ServiceInstanceRelation();
        serviceInstanceRelation.setSourceServiceInstanceId(this.sourceServiceInstanceId);
        serviceInstanceRelation.setSourceServiceId(this.sourceServiceId);
        serviceInstanceRelation.setSourceServiceName(this.sourceServiceName);
        serviceInstanceRelation.setSourceServiceInstanceName(this.sourceServiceInstanceName);
        serviceInstanceRelation.setSourceServiceId(this.destServiceId);
        serviceInstanceRelation.setDestServiceInstanceId(this.destServiceInstanceId);
        serviceInstanceRelation.setDestServiceName(this.destServiceName);
        serviceInstanceRelation.setDestServiceInstanceName(this.destServiceInstanceName);
        serviceInstanceRelation.setEndpoint(this.destEndpointName);
        serviceInstanceRelation.setComponentId(this.componentId);
        serviceInstanceRelation.setLatency(this.latency);
        serviceInstanceRelation.setStatus(this.status);
        serviceInstanceRelation.setResponseCode(this.responseCode);
        serviceInstanceRelation.setType(this.type);
        serviceInstanceRelation.setDetectPoint(this.detectPoint);
        serviceInstanceRelation.setTimeBucket(this.timeBucket);
        return serviceInstanceRelation;
    }

    Endpoint toEndpoint() {
        Endpoint endpoint = new Endpoint();
        endpoint.setId(this.destEndpointId);
        endpoint.setName(this.destEndpointName);
        endpoint.setServiceId(this.destServiceId);
        endpoint.setServiceName(this.destServiceName);
        endpoint.setServiceInstanceId(this.destServiceInstanceId);
        endpoint.setServiceInstanceName(this.destServiceInstanceName);
        endpoint.setLatency(this.latency);
        endpoint.setStatus(this.status);
        endpoint.setResponseCode(this.responseCode);
        endpoint.setType(this.type);
        endpoint.setTimeBucket(this.timeBucket);
        return endpoint;
    }

    EndpointRelation toEndpointRelation() {
        if (StringUtil.isEmpty((String)this.sourceEndpointName) || StringUtil.isEmpty((String)this.destEndpointName)) {
            return null;
        }
        EndpointRelation endpointRelation = new EndpointRelation();
        endpointRelation.setEndpointId(this.sourceEndpointId);
        endpointRelation.setEndpoint(this.sourceEndpointName);
        endpointRelation.setServiceId(this.sourceServiceId);
        endpointRelation.setServiceName(this.sourceServiceName);
        endpointRelation.setServiceInstanceId(this.sourceServiceInstanceId);
        endpointRelation.setServiceInstanceName(this.sourceServiceInstanceName);
        endpointRelation.setChildEndpointId(this.destEndpointId);
        endpointRelation.setChildEndpoint(this.destEndpointName);
        endpointRelation.setChildServiceId(this.destServiceId);
        endpointRelation.setChildServiceName(this.destServiceName);
        endpointRelation.setChildServiceInstanceId(this.destServiceInstanceId);
        endpointRelation.setChildServiceInstanceName(this.destServiceInstanceName);
        endpointRelation.setComponentId(this.componentId);
        endpointRelation.setRpcLatency(this.latency);
        endpointRelation.setStatus(this.status);
        endpointRelation.setResponseCode(this.responseCode);
        endpointRelation.setType(this.type);
        endpointRelation.setDetectPoint(this.detectPoint);
        endpointRelation.setTimeBucket(this.timeBucket);
        return endpointRelation;
    }

    DatabaseAccess toDatabaseAccess() {
        if (!RequestType.DATABASE.equals((Object)this.type)) {
            return null;
        }
        DatabaseAccess databaseAccess = new DatabaseAccess();
        databaseAccess.setId((long)this.destServiceId);
        databaseAccess.setDatabaseTypeId(this.componentId);
        databaseAccess.setLatency(this.latency);
        databaseAccess.setName(this.destServiceName);
        databaseAccess.setStatus(this.status);
        databaseAccess.setTimeBucket(this.timeBucket);
        return databaseAccess;
    }

    public int getSourceServiceId() {
        return this.sourceServiceId;
    }

    public void setSourceServiceId(int sourceServiceId) {
        this.sourceServiceId = sourceServiceId;
    }

    public String getSourceServiceName() {
        return this.sourceServiceName;
    }

    public void setSourceServiceName(String sourceServiceName) {
        this.sourceServiceName = sourceServiceName;
    }

    public int getSourceServiceInstanceId() {
        return this.sourceServiceInstanceId;
    }

    public void setSourceServiceInstanceId(int sourceServiceInstanceId) {
        this.sourceServiceInstanceId = sourceServiceInstanceId;
    }

    public String getSourceServiceInstanceName() {
        return this.sourceServiceInstanceName;
    }

    public void setSourceServiceInstanceName(String sourceServiceInstanceName) {
        this.sourceServiceInstanceName = sourceServiceInstanceName;
    }

    public int getSourceEndpointId() {
        return this.sourceEndpointId;
    }

    public void setSourceEndpointId(int sourceEndpointId) {
        this.sourceEndpointId = sourceEndpointId;
    }

    public String getSourceEndpointName() {
        return this.sourceEndpointName;
    }

    public void setSourceEndpointName(String sourceEndpointName) {
        this.sourceEndpointName = sourceEndpointName;
    }

    public int getDestServiceId() {
        return this.destServiceId;
    }

    public void setDestServiceId(int destServiceId) {
        this.destServiceId = destServiceId;
    }

    public String getDestServiceName() {
        return this.destServiceName;
    }

    public void setDestServiceName(String destServiceName) {
        this.destServiceName = destServiceName;
    }

    public int getDestServiceInstanceId() {
        return this.destServiceInstanceId;
    }

    public void setDestServiceInstanceId(int destServiceInstanceId) {
        this.destServiceInstanceId = destServiceInstanceId;
    }

    public String getDestServiceInstanceName() {
        return this.destServiceInstanceName;
    }

    public void setDestServiceInstanceName(String destServiceInstanceName) {
        this.destServiceInstanceName = destServiceInstanceName;
    }

    public int getDestEndpointId() {
        return this.destEndpointId;
    }

    public void setDestEndpointId(int destEndpointId) {
        this.destEndpointId = destEndpointId;
    }

    public String getDestEndpointName() {
        return this.destEndpointName;
    }

    public void setDestEndpointName(String destEndpointName) {
        this.destEndpointName = destEndpointName;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public RequestType getType() {
        return this.type;
    }

    public void setType(RequestType type) {
        this.type = type;
    }

    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    public long getTimeBucket() {
        return this.timeBucket;
    }

    public void setTimeBucket(long timeBucket) {
        this.timeBucket = timeBucket;
    }
}

