/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.network.language.agent.SpanType;
import org.apache.skywalking.apm.network.language.agent.TraceSegmentObject;
import org.apache.skywalking.apm.network.language.agent.UniqueId;
import org.apache.skywalking.apm.network.language.agent.UpstreamSegment;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.library.buffer.BufferData;
import org.apache.skywalking.oap.server.library.buffer.DataStreamReader;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.TraceServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.SegmentParserListenerManager;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.ReferenceDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SegmentCoreInfo;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SegmentDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.decorator.SpanDecorator;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.EntrySpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.ExitSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.FirstSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.GlobalTraceIdsListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.LocalSpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.listener.SpanListener;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.ReferenceIdExchanger;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.SegmentStandardization;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.SegmentStandardizationWorker;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.SpanIdExchanger;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentParse {
    private static final Logger logger = LoggerFactory.getLogger(SegmentParse.class);
    private final ModuleManager moduleManager;
    private final List<SpanListener> spanListeners;
    private final SegmentParserListenerManager listenerManager;
    private final SegmentCoreInfo segmentCoreInfo;
    private final TraceServiceModuleConfig config;
    private SegmentStandardizationWorker standardizationWorker;
    private static volatile CounterMetrics TRACE_BUFFER_FILE_RETRY;
    private static volatile CounterMetrics TRACE_BUFFER_FILE_OUT;
    private static volatile CounterMetrics TRACE_PARSE_ERROR;

    private SegmentParse(ModuleManager moduleManager, SegmentParserListenerManager listenerManager, TraceServiceModuleConfig config) {
        this.moduleManager = moduleManager;
        this.listenerManager = listenerManager;
        this.spanListeners = new LinkedList<SpanListener>();
        this.segmentCoreInfo = new SegmentCoreInfo();
        this.segmentCoreInfo.setStartTime(Long.MAX_VALUE);
        this.segmentCoreInfo.setEndTime(Long.MIN_VALUE);
        this.segmentCoreInfo.setV2(false);
        this.config = config;
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        TRACE_BUFFER_FILE_RETRY = metricsCreator.createCounter("v5_trace_buffer_file_retry", "The number of retry trace segment from the buffer file, but haven't registered successfully.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        TRACE_BUFFER_FILE_OUT = metricsCreator.createCounter("v5_trace_buffer_file_out", "The number of trace segment out of the buffer file", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        TRACE_PARSE_ERROR = metricsCreator.createCounter("v5_trace_parse_error", "The number of trace segment out of the buffer file", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
    }

    public boolean parse(BufferData<UpstreamSegment> bufferData, Source source) {
        this.createSpanListeners();
        try {
            TraceSegmentObject segmentObject;
            SegmentDecorator segmentDecorator;
            UpstreamSegment upstreamSegment = (UpstreamSegment)bufferData.getMessageType();
            List traceIds = upstreamSegment.getGlobalTraceIdsList();
            if (bufferData.getV1Segment() == null) {
                bufferData.setV1Segment(this.parseBinarySegment(upstreamSegment));
            }
            if (!this.preBuild(traceIds, segmentDecorator = new SegmentDecorator(segmentObject = bufferData.getV1Segment()))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("This segment id exchange not success, write to buffer file, id: {}", (Object)this.segmentCoreInfo.getSegmentId());
                }
                if (source.equals((Object)Source.Agent)) {
                    this.writeToBufferFile(this.segmentCoreInfo.getSegmentId(), upstreamSegment);
                } else {
                    TRACE_BUFFER_FILE_RETRY.inc();
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("This segment id exchange success, id: {}", (Object)this.segmentCoreInfo.getSegmentId());
            }
            TRACE_BUFFER_FILE_OUT.inc();
            this.notifyListenerToBuild();
            return true;
        }
        catch (Throwable e) {
            TRACE_PARSE_ERROR.inc();
            logger.error(e.getMessage(), e);
            return true;
        }
    }

    private TraceSegmentObject parseBinarySegment(UpstreamSegment segment) throws InvalidProtocolBufferException {
        return TraceSegmentObject.parseFrom((ByteString)segment.getSegment());
    }

    private boolean preBuild(List<UniqueId> traceIds, SegmentDecorator segmentDecorator) {
        StringBuilder segmentIdBuilder = new StringBuilder();
        for (int i = 0; i < segmentDecorator.getTraceSegmentId().getIdPartsList().size(); ++i) {
            if (i == 0) {
                segmentIdBuilder.append(segmentDecorator.getTraceSegmentId().getIdPartsList().get(i));
                continue;
            }
            segmentIdBuilder.append(".").append(segmentDecorator.getTraceSegmentId().getIdPartsList().get(i));
        }
        for (UniqueId uniqueId : traceIds) {
            this.notifyGlobalsListener(uniqueId);
        }
        this.segmentCoreInfo.setSegmentId(segmentIdBuilder.toString());
        this.segmentCoreInfo.setServiceId(segmentDecorator.getServiceId());
        this.segmentCoreInfo.setServiceInstanceId(segmentDecorator.getServiceInstanceId());
        this.segmentCoreInfo.setDataBinary(segmentDecorator.toByteArray());
        this.segmentCoreInfo.setV2(false);
        boolean exchanged = true;
        for (int i = 0; i < segmentDecorator.getSpansCount(); ++i) {
            SpanDecorator spanDecorator = segmentDecorator.getSpans(i);
            if (!SpanIdExchanger.getInstance(this.moduleManager).exchange(spanDecorator, this.segmentCoreInfo.getServiceId())) {
                exchanged = false;
            } else {
                for (int j = 0; j < spanDecorator.getRefsCount(); ++j) {
                    ReferenceDecorator referenceDecorator = spanDecorator.getRefs(j);
                    if (ReferenceIdExchanger.getInstance(this.moduleManager).exchange(referenceDecorator, this.segmentCoreInfo.getServiceId())) continue;
                    exchanged = false;
                }
            }
            if (this.segmentCoreInfo.getStartTime() > spanDecorator.getStartTime()) {
                this.segmentCoreInfo.setStartTime(spanDecorator.getStartTime());
            }
            if (this.segmentCoreInfo.getEndTime() < spanDecorator.getEndTime()) {
                this.segmentCoreInfo.setEndTime(spanDecorator.getEndTime());
            }
            this.segmentCoreInfo.setError(spanDecorator.getIsError() || this.segmentCoreInfo.isError());
        }
        if (exchanged) {
            long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)this.segmentCoreInfo.getStartTime());
            this.segmentCoreInfo.setMinuteTimeBucket(minuteTimeBucket);
            for (int i = 0; i < segmentDecorator.getSpansCount(); ++i) {
                SpanDecorator spanDecorator = segmentDecorator.getSpans(i);
                if (spanDecorator.getSpanId() == 0) {
                    this.notifyFirstListener(spanDecorator);
                }
                if (SpanType.Exit.equals((Object)spanDecorator.getSpanType())) {
                    this.notifyExitListener(spanDecorator);
                    continue;
                }
                if (SpanType.Entry.equals((Object)spanDecorator.getSpanType())) {
                    this.notifyEntryListener(spanDecorator);
                    continue;
                }
                if (SpanType.Local.equals((Object)spanDecorator.getSpanType())) {
                    this.notifyLocalListener(spanDecorator);
                    continue;
                }
                logger.error("span type value was unexpected, span type name: {}", (Object)spanDecorator.getSpanType().name());
            }
        }
        return exchanged;
    }

    private void writeToBufferFile(String id, UpstreamSegment upstreamSegment) {
        if (logger.isDebugEnabled()) {
            logger.debug("push to segment buffer write worker, id: {}", (Object)id);
        }
        SegmentStandardization standardization = new SegmentStandardization(id);
        standardization.setUpstreamSegment(upstreamSegment);
        this.standardizationWorker.in(standardization);
    }

    private void notifyListenerToBuild() {
        this.spanListeners.forEach(SpanListener::build);
    }

    private void notifyExitListener(SpanDecorator spanDecorator) {
        this.spanListeners.forEach(listener -> {
            if (listener.containsPoint(SpanListener.Point.Exit)) {
                ((ExitSpanListener)listener).parseExit(spanDecorator, this.segmentCoreInfo);
            }
        });
    }

    private void notifyEntryListener(SpanDecorator spanDecorator) {
        this.spanListeners.forEach(listener -> {
            if (listener.containsPoint(SpanListener.Point.Entry)) {
                ((EntrySpanListener)listener).parseEntry(spanDecorator, this.segmentCoreInfo);
            }
        });
    }

    private void notifyLocalListener(SpanDecorator spanDecorator) {
        this.spanListeners.forEach(listener -> {
            if (listener.containsPoint(SpanListener.Point.Local)) {
                ((LocalSpanListener)listener).parseLocal(spanDecorator, this.segmentCoreInfo);
            }
        });
    }

    private void notifyFirstListener(SpanDecorator spanDecorator) {
        this.spanListeners.forEach(listener -> {
            if (listener.containsPoint(SpanListener.Point.First)) {
                ((FirstSpanListener)listener).parseFirst(spanDecorator, this.segmentCoreInfo);
            }
        });
    }

    private void notifyGlobalsListener(UniqueId uniqueId) {
        this.spanListeners.forEach(listener -> {
            if (listener.containsPoint(SpanListener.Point.TraceIds)) {
                ((GlobalTraceIdsListener)listener).parseGlobalTraceId(uniqueId, this.segmentCoreInfo);
            }
        });
    }

    private void createSpanListeners() {
        this.listenerManager.getSpanListenerFactories().forEach(spanListenerFactory -> this.spanListeners.add(spanListenerFactory.create(this.moduleManager, this.config)));
    }

    public void setStandardizationWorker(SegmentStandardizationWorker standardizationWorker) {
        this.standardizationWorker = standardizationWorker;
    }

    public static class Producer
    implements DataStreamReader.CallBack<UpstreamSegment> {
        private SegmentStandardizationWorker standardizationWorker;
        private final ModuleManager moduleManager;
        private final SegmentParserListenerManager listenerManager;
        private final TraceServiceModuleConfig config;

        public Producer(ModuleManager moduleManager, SegmentParserListenerManager listenerManager, TraceServiceModuleConfig config) {
            this.moduleManager = moduleManager;
            this.listenerManager = listenerManager;
            this.config = config;
        }

        public void send(UpstreamSegment segment, Source source) {
            SegmentParse segmentParse = new SegmentParse(this.moduleManager, this.listenerManager, this.config);
            segmentParse.setStandardizationWorker(this.standardizationWorker);
            segmentParse.parse((BufferData<UpstreamSegment>)new BufferData((GeneratedMessageV3)segment), source);
        }

        public boolean call(BufferData<UpstreamSegment> bufferData) {
            SegmentParse segmentParse = new SegmentParse(this.moduleManager, this.listenerManager, this.config);
            segmentParse.setStandardizationWorker(this.standardizationWorker);
            boolean parseResult = segmentParse.parse(bufferData, Source.Buffer);
            if (parseResult) {
                TRACE_BUFFER_FILE_OUT.inc();
            }
            return parseResult;
        }

        public void setStandardizationWorker(SegmentStandardizationWorker standardizationWorker) {
            this.standardizationWorker = standardizationWorker;
        }
    }

    public static enum Source {
        Agent,
        Buffer;

    }
}

