/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import org.apache.skywalking.apm.network.language.agent.SpanObject;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.KeyWithStringValueJsonReader;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.LogJsonReader;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.ReferenceJsonReader;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.StreamJsonReader;

public class SpanJsonReader
implements StreamJsonReader<SpanObject> {
    private KeyWithStringValueJsonReader keyWithStringValueJsonReader = new KeyWithStringValueJsonReader();
    private LogJsonReader logJsonReader = new LogJsonReader();
    private ReferenceJsonReader referenceJsonReader = new ReferenceJsonReader();
    private static final String SPAN_ID = "si";
    private static final String SPAN_TYPE_VALUE = "tv";
    private static final String SPAN_LAYER_VALUE = "lv";
    private static final String PARENT_SPAN_ID = "ps";
    private static final String START_TIME = "st";
    private static final String END_TIME = "et";
    private static final String COMPONENT_ID = "ci";
    private static final String COMPONENT_NAME = "cn";
    private static final String OPERATION_NAME_ID = "oi";
    private static final String OPERATION_NAME = "on";
    private static final String PEER_ID = "pi";
    private static final String PEER = "pn";
    private static final String IS_ERROR = "ie";
    private static final String TRACE_SEGMENT_REFERENCE = "rs";
    private static final String TAGS = "to";
    private static final String LOGS = "lo";

    @Override
    public SpanObject read(JsonReader reader) throws IOException {
        SpanObject.Builder builder = SpanObject.newBuilder();
        reader.beginObject();
        block36: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "si": {
                    builder.setSpanId(reader.nextInt());
                    continue block36;
                }
                case "tv": {
                    builder.setSpanTypeValue(reader.nextInt());
                    continue block36;
                }
                case "lv": {
                    builder.setSpanLayerValue(reader.nextInt());
                    continue block36;
                }
                case "ps": {
                    builder.setParentSpanId(reader.nextInt());
                    continue block36;
                }
                case "st": {
                    builder.setStartTime(reader.nextLong());
                    continue block36;
                }
                case "et": {
                    builder.setEndTime(reader.nextLong());
                    continue block36;
                }
                case "ci": {
                    builder.setComponentId(reader.nextInt());
                    continue block36;
                }
                case "cn": {
                    builder.setComponent(reader.nextString());
                    continue block36;
                }
                case "oi": {
                    builder.setOperationNameId(reader.nextInt());
                    continue block36;
                }
                case "on": {
                    builder.setOperationName(reader.nextString());
                    continue block36;
                }
                case "pi": {
                    builder.setPeerId(reader.nextInt());
                    continue block36;
                }
                case "pn": {
                    builder.setPeer(reader.nextString());
                    continue block36;
                }
                case "ie": {
                    builder.setIsError(reader.nextBoolean());
                    continue block36;
                }
                case "rs": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        builder.addRefs(this.referenceJsonReader.read(reader));
                    }
                    reader.endArray();
                    continue block36;
                }
                case "to": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        builder.addTags(this.keyWithStringValueJsonReader.read(reader));
                    }
                    reader.endArray();
                    continue block36;
                }
                case "lo": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        builder.addLogs(this.logJsonReader.read(reader));
                    }
                    reader.endArray();
                    continue block36;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return builder.build();
    }
}

