/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import org.apache.skywalking.apm.network.language.agent.TraceSegmentObject;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.SpanJsonReader;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.StreamJsonReader;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v5.rest.reader.UniqueIdJsonReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentJsonReader
implements StreamJsonReader<TraceSegmentObject.Builder> {
    private static final Logger logger = LoggerFactory.getLogger(SegmentJsonReader.class);
    private UniqueIdJsonReader uniqueIdJsonReader = new UniqueIdJsonReader();
    private SpanJsonReader spanJsonReader = new SpanJsonReader();
    private static final String TRACE_SEGMENT_ID = "ts";
    private static final String APPLICATION_ID = "ai";
    private static final String APPLICATION_INSTANCE_ID = "ii";
    private static final String SPANS = "ss";

    @Override
    public TraceSegmentObject.Builder read(JsonReader reader) throws IOException {
        TraceSegmentObject.Builder builder = TraceSegmentObject.newBuilder();
        reader.beginObject();
        block12: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "ts": {
                    builder.setTraceSegmentId(this.uniqueIdJsonReader.read(reader));
                    if (!logger.isDebugEnabled()) continue block12;
                    StringBuilder segmentId = new StringBuilder();
                    builder.getTraceSegmentId().getIdPartsList().forEach(idPart -> segmentId.append(idPart));
                    logger.debug("segment id: {}", (Object)segmentId);
                    continue block12;
                }
                case "ai": {
                    builder.setApplicationId(reader.nextInt());
                    continue block12;
                }
                case "ii": {
                    builder.setApplicationInstanceId(reader.nextInt());
                    continue block12;
                }
                case "ss": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        builder.addSpans(this.spanJsonReader.read(reader));
                    }
                    reader.endArray();
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return builder;
    }
}

