/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.servicerelation;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientCallSlaMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientCpmMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientP50Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientP75Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientP90Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientP95Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientP99Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationClientRespTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerCallSlaMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerCpmMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerP50Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerP75Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerP90Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerP95Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerP99Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.servicerelation.ServiceRelationServerRespTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ServiceRelation;

public class ServiceRelationDispatcher
implements SourceDispatcher<ServiceRelation> {
    public void dispatch(ServiceRelation source) {
        this.doServiceRelationClientCpm(source);
        this.doServiceRelationServerCpm(source);
        this.doServiceRelationClientCallSla(source);
        this.doServiceRelationServerCallSla(source);
        this.doServiceRelationClientRespTime(source);
        this.doServiceRelationServerRespTime(source);
        this.doServiceRelationClientP99(source);
        this.doServiceRelationServerP99(source);
        this.doServiceRelationClientP95(source);
        this.doServiceRelationServerP95(source);
        this.doServiceRelationClientP90(source);
        this.doServiceRelationServerP90(source);
        this.doServiceRelationClientP75(source);
        this.doServiceRelationServerP75(source);
        this.doServiceRelationClientP50(source);
        this.doServiceRelationServerP50(source);
    }

    private void doServiceRelationClientCpm(ServiceRelation source) {
        ServiceRelationClientCpmMetrics metrics = new ServiceRelationClientCpmMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(1L);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerCpm(ServiceRelation source) {
        ServiceRelationServerCpmMetrics metrics = new ServiceRelationServerCpmMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(1L);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationClientCallSla(ServiceRelation source) {
        ServiceRelationClientCallSlaMetrics metrics = new ServiceRelationClientCallSlaMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(new EqualMatch(), source.isStatus(), true);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerCallSla(ServiceRelation source) {
        ServiceRelationServerCallSlaMetrics metrics = new ServiceRelationServerCallSlaMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(new EqualMatch(), source.isStatus(), true);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationClientRespTime(ServiceRelation source) {
        ServiceRelationClientRespTimeMetrics metrics = new ServiceRelationClientRespTimeMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerRespTime(ServiceRelation source) {
        ServiceRelationServerRespTimeMetrics metrics = new ServiceRelationServerRespTimeMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationClientP99(ServiceRelation source) {
        ServiceRelationClientP99Metrics metrics = new ServiceRelationClientP99Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerP99(ServiceRelation source) {
        ServiceRelationServerP99Metrics metrics = new ServiceRelationServerP99Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationClientP95(ServiceRelation source) {
        ServiceRelationClientP95Metrics metrics = new ServiceRelationClientP95Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerP95(ServiceRelation source) {
        ServiceRelationServerP95Metrics metrics = new ServiceRelationServerP95Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationClientP90(ServiceRelation source) {
        ServiceRelationClientP90Metrics metrics = new ServiceRelationClientP90Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerP90(ServiceRelation source) {
        ServiceRelationServerP90Metrics metrics = new ServiceRelationServerP90Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationClientP75(ServiceRelation source) {
        ServiceRelationClientP75Metrics metrics = new ServiceRelationClientP75Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerP75(ServiceRelation source) {
        ServiceRelationServerP75Metrics metrics = new ServiceRelationServerP75Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationClientP50(ServiceRelation source) {
        ServiceRelationClientP50Metrics metrics = new ServiceRelationClientP50Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.CLIENT).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceRelationServerP50(ServiceRelation source) {
        ServiceRelationServerP50Metrics metrics = new ServiceRelationServerP50Metrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

