/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmmemory;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmmemory.InstanceJvmMemoryHeapMaxMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmmemory.InstanceJvmMemoryHeapMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmmemory.InstanceJvmMemoryNoheapMaxMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmmemory.InstanceJvmMemoryNoheapMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceJVMMemory;

public class ServiceInstanceJVMMemoryDispatcher
implements SourceDispatcher<ServiceInstanceJVMMemory> {
    public void dispatch(ServiceInstanceJVMMemory source) {
        this.doInstanceJvmMemoryHeap(source);
        this.doInstanceJvmMemoryNoheap(source);
        this.doInstanceJvmMemoryHeapMax(source);
        this.doInstanceJvmMemoryNoheapMax(source);
    }

    private void doInstanceJvmMemoryHeap(ServiceInstanceJVMMemory source) {
        InstanceJvmMemoryHeapMetrics metrics = new InstanceJvmMemoryHeapMetrics();
        if (!new EqualMatch().setLeft((Object)source.isHeapStatus()).setRight((Object)true).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getUsed(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceJvmMemoryNoheap(ServiceInstanceJVMMemory source) {
        InstanceJvmMemoryNoheapMetrics metrics = new InstanceJvmMemoryNoheapMetrics();
        if (!new EqualMatch().setLeft((Object)source.isHeapStatus()).setRight((Object)false).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getUsed(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceJvmMemoryHeapMax(ServiceInstanceJVMMemory source) {
        InstanceJvmMemoryHeapMaxMetrics metrics = new InstanceJvmMemoryHeapMaxMetrics();
        if (!new EqualMatch().setLeft((Object)source.isHeapStatus()).setRight((Object)true).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getMax(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceJvmMemoryNoheapMax(ServiceInstanceJVMMemory source) {
        InstanceJvmMemoryNoheapMaxMetrics metrics = new InstanceJvmMemoryNoheapMaxMetrics();
        if (!new EqualMatch().setLeft((Object)source.isHeapStatus()).setRight((Object)false).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getMax(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

