/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmgc;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmgc.InstanceJvmOldGcCountMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmgc.InstanceJvmOldGcTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmgc.InstanceJvmYoungGcCountMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmgc.InstanceJvmYoungGcTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.GCPhrase;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceJVMGC;

public class ServiceInstanceJVMGCDispatcher
implements SourceDispatcher<ServiceInstanceJVMGC> {
    public void dispatch(ServiceInstanceJVMGC source) {
        this.doInstanceJvmYoungGcTime(source);
        this.doInstanceJvmOldGcTime(source);
        this.doInstanceJvmYoungGcCount(source);
        this.doInstanceJvmOldGcCount(source);
    }

    private void doInstanceJvmYoungGcTime(ServiceInstanceJVMGC source) {
        InstanceJvmYoungGcTimeMetrics metrics = new InstanceJvmYoungGcTimeMetrics();
        if (!new EqualMatch().setLeft((Object)source.getPhrase()).setRight((Object)GCPhrase.NEW).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getTime(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceJvmOldGcTime(ServiceInstanceJVMGC source) {
        InstanceJvmOldGcTimeMetrics metrics = new InstanceJvmOldGcTimeMetrics();
        if (!new EqualMatch().setLeft((Object)source.getPhrase()).setRight((Object)GCPhrase.OLD).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getTime(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceJvmYoungGcCount(ServiceInstanceJVMGC source) {
        InstanceJvmYoungGcCountMetrics metrics = new InstanceJvmYoungGcCountMetrics();
        if (!new EqualMatch().setLeft((Object)source.getPhrase()).setRight((Object)GCPhrase.NEW).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getCount());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceJvmOldGcCount(ServiceInstanceJVMGC source) {
        InstanceJvmOldGcCountMetrics metrics = new InstanceJvmOldGcCountMetrics();
        if (!new EqualMatch().setLeft((Object)source.getPhrase()).setRight((Object)GCPhrase.OLD).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getCount());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

