/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.serviceinstancejvmgc;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongAvgMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="instance_jvm_old_gc_time", scopeId=11, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class InstanceJvmOldGcTimeMetrics
extends LongAvgMetrics
implements WithMetadata {
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;
    @Column(columnName="service_id")
    private int serviceId;

    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.entityId;
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InstanceJvmOldGcTimeMetrics metrics = (InstanceJvmOldGcTimeMetrics)((Object)obj);
        if (!this.entityId.equals(metrics.entityId)) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataLongs(this.getSummation());
        remoteBuilder.addDataLongs(this.getValue());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataIntegers(this.getServiceId());
        remoteBuilder.addDataIntegers(this.getCount());
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSummation(remoteData.getDataLongs(0));
        this.setValue(remoteData.getDataLongs(1));
        this.setTimeBucket(remoteData.getDataLongs(2));
        this.setServiceId(remoteData.getDataIntegers(0));
        this.setCount(remoteData.getDataIntegers(1));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("instance_jvm_old_gc_time", 11, this.entityId);
    }

    public Metrics toHour() {
        InstanceJvmOldGcTimeMetrics metrics = new InstanceJvmOldGcTimeMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        InstanceJvmOldGcTimeMetrics metrics = new InstanceJvmOldGcTimeMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        InstanceJvmOldGcTimeMetrics metrics = new InstanceJvmOldGcTimeMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public static class Builder
    implements StorageBuilder<InstanceJvmOldGcTimeMetrics> {
        public Map<String, Object> data2Map(InstanceJvmOldGcTimeMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity_id", storageData.getEntityId());
            map.put("service_id", storageData.getServiceId());
            map.put("summation", storageData.getSummation());
            map.put("count", storageData.getCount());
            map.put("value", storageData.getValue());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public InstanceJvmOldGcTimeMetrics map2Data(Map<String, Object> dbMap) {
            InstanceJvmOldGcTimeMetrics metrics = new InstanceJvmOldGcTimeMetrics();
            metrics.setEntityId((String)dbMap.get("entity_id"));
            metrics.setServiceId(((Number)dbMap.get("service_id")).intValue());
            metrics.setSummation(((Number)dbMap.get("summation")).longValue());
            metrics.setCount(((Number)dbMap.get("count")).intValue());
            metrics.setValue(((Number)dbMap.get("value")).longValue());
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

