/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrthread;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrthread.InstanceClrAvailableCompletionPortThreadsMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrthread.InstanceClrAvailableWorkerThreadsMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrthread.InstanceClrMaxCompletionPortThreadsMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrthread.InstanceClrMaxWorkerThreadsMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRThread;

public class ServiceInstanceCLRThreadDispatcher
implements SourceDispatcher<ServiceInstanceCLRThread> {
    public void dispatch(ServiceInstanceCLRThread source) {
        this.doInstanceClrAvailableCompletionPortThreads(source);
        this.doInstanceClrAvailableWorkerThreads(source);
        this.doInstanceClrMaxCompletionPortThreads(source);
        this.doInstanceClrMaxWorkerThreads(source);
    }

    private void doInstanceClrAvailableCompletionPortThreads(ServiceInstanceCLRThread source) {
        InstanceClrAvailableCompletionPortThreadsMetrics metrics = new InstanceClrAvailableCompletionPortThreadsMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getAvailableCompletionPortThreads());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceClrAvailableWorkerThreads(ServiceInstanceCLRThread source) {
        InstanceClrAvailableWorkerThreadsMetrics metrics = new InstanceClrAvailableWorkerThreadsMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getAvailableWorkerThreads());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceClrMaxCompletionPortThreads(ServiceInstanceCLRThread source) {
        InstanceClrMaxCompletionPortThreadsMetrics metrics = new InstanceClrMaxCompletionPortThreadsMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getMaxCompletionPortThreads());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceClrMaxWorkerThreads(ServiceInstanceCLRThread source) {
        InstanceClrMaxWorkerThreadsMetrics metrics = new InstanceClrMaxWorkerThreadsMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getMaxWorkerThreads());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

