/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrthread;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.MaxLongMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="instance_clr_max_completion_port_threads", scopeId=21, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class InstanceClrMaxCompletionPortThreadsMetrics
extends MaxLongMetrics
implements WithMetadata {
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;
    @Column(columnName="service_id")
    private int serviceId;

    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.entityId;
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InstanceClrMaxCompletionPortThreadsMetrics metrics = (InstanceClrMaxCompletionPortThreadsMetrics)((Object)obj);
        if (!this.entityId.equals(metrics.entityId)) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataLongs(this.getValue());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataIntegers(this.getServiceId());
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setValue(remoteData.getDataLongs(0));
        this.setTimeBucket(remoteData.getDataLongs(1));
        this.setServiceId(remoteData.getDataIntegers(0));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("instance_clr_max_completion_port_threads", 21, this.entityId);
    }

    public Metrics toHour() {
        InstanceClrMaxCompletionPortThreadsMetrics metrics = new InstanceClrMaxCompletionPortThreadsMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        InstanceClrMaxCompletionPortThreadsMetrics metrics = new InstanceClrMaxCompletionPortThreadsMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        InstanceClrMaxCompletionPortThreadsMetrics metrics = new InstanceClrMaxCompletionPortThreadsMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public static class Builder
    implements StorageBuilder<InstanceClrMaxCompletionPortThreadsMetrics> {
        public Map<String, Object> data2Map(InstanceClrMaxCompletionPortThreadsMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity_id", storageData.getEntityId());
            map.put("service_id", storageData.getServiceId());
            map.put("value", storageData.getValue());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public InstanceClrMaxCompletionPortThreadsMetrics map2Data(Map<String, Object> dbMap) {
            InstanceClrMaxCompletionPortThreadsMetrics metrics = new InstanceClrMaxCompletionPortThreadsMetrics();
            metrics.setEntityId((String)dbMap.get("entity_id"));
            metrics.setServiceId(((Number)dbMap.get("service_id")).intValue());
            metrics.setValue(((Number)dbMap.get("value")).longValue());
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

