/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrgc;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrgc.InstanceClrGen0CollectCountMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrgc.InstanceClrGen1CollectCountMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrgc.InstanceClrGen2CollectCountMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstanceclrgc.InstanceClrHeapMemoryMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRGC;

public class ServiceInstanceCLRGCDispatcher
implements SourceDispatcher<ServiceInstanceCLRGC> {
    public void dispatch(ServiceInstanceCLRGC source) {
        this.doInstanceClrGen0CollectCount(source);
        this.doInstanceClrGen1CollectCount(source);
        this.doInstanceClrGen2CollectCount(source);
        this.doInstanceClrHeapMemory(source);
    }

    private void doInstanceClrGen0CollectCount(ServiceInstanceCLRGC source) {
        InstanceClrGen0CollectCountMetrics metrics = new InstanceClrGen0CollectCountMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getGen0CollectCount());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceClrGen1CollectCount(ServiceInstanceCLRGC source) {
        InstanceClrGen1CollectCountMetrics metrics = new InstanceClrGen1CollectCountMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getGen1CollectCount());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceClrGen2CollectCount(ServiceInstanceCLRGC source) {
        InstanceClrGen2CollectCountMetrics metrics = new InstanceClrGen2CollectCountMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getGen2CollectCount());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doInstanceClrHeapMemory(ServiceInstanceCLRGC source) {
        InstanceClrHeapMemoryMetrics metrics = new InstanceClrHeapMemoryMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getHeapMemory(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

