/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.serviceinstance;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstance.ServiceInstanceCpmMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstance.ServiceInstanceRespTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.serviceinstance.ServiceInstanceSlaMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ServiceInstance;

public class ServiceInstanceDispatcher
implements SourceDispatcher<ServiceInstance> {
    public void dispatch(ServiceInstance source) {
        this.doServiceInstanceSla(source);
        this.doServiceInstanceRespTime(source);
        this.doServiceInstanceCpm(source);
    }

    private void doServiceInstanceSla(ServiceInstance source) {
        ServiceInstanceSlaMetrics metrics = new ServiceInstanceSlaMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(new EqualMatch(), source.isStatus(), true);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceInstanceRespTime(ServiceInstance source) {
        ServiceInstanceRespTimeMetrics metrics = new ServiceInstanceRespTimeMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getLatency(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceInstanceCpm(ServiceInstance source) {
        ServiceInstanceCpmMetrics metrics = new ServiceInstanceCpmMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(1L);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

