/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.service;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceCpmMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceP50Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceP75Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceP90Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceP95Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceP99Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceRespTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.service.ServiceSlaMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.Service;

public class ServiceDispatcher
implements SourceDispatcher<Service> {
    public void dispatch(Service source) {
        this.doServiceRespTime(source);
        this.doServiceSla(source);
        this.doServiceCpm(source);
        this.doServiceP99(source);
        this.doServiceP95(source);
        this.doServiceP90(source);
        this.doServiceP75(source);
        this.doServiceP50(source);
    }

    private void doServiceRespTime(Service source) {
        ServiceRespTimeMetrics metrics = new ServiceRespTimeMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceSla(Service source) {
        ServiceSlaMetrics metrics = new ServiceSlaMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(new EqualMatch(), source.isStatus(), true);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceCpm(Service source) {
        ServiceCpmMetrics metrics = new ServiceCpmMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(1L);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceP99(Service source) {
        ServiceP99Metrics metrics = new ServiceP99Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceP95(Service source) {
        ServiceP95Metrics metrics = new ServiceP95Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceP90(Service source) {
        ServiceP90Metrics metrics = new ServiceP90Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceP75(Service source) {
        ServiceP75Metrics metrics = new ServiceP75Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doServiceP50(Service source) {
        ServiceP50Metrics metrics = new ServiceP50Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

