/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.CPMMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="service_cpm", scopeId=1, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class ServiceCpmMetrics
extends CPMMetrics
implements WithMetadata {
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;

    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.entityId;
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServiceCpmMetrics metrics = (ServiceCpmMetrics)((Object)obj);
        if (!this.entityId.equals(metrics.entityId)) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataLongs(this.getValue());
        remoteBuilder.addDataLongs(this.getTotal());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setValue(remoteData.getDataLongs(0));
        this.setTotal(remoteData.getDataLongs(1));
        this.setTimeBucket(remoteData.getDataLongs(2));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("service_cpm", 1, this.entityId);
    }

    public Metrics toHour() {
        ServiceCpmMetrics metrics = new ServiceCpmMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setValue(this.getValue());
        metrics.setTotal(this.getTotal());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        ServiceCpmMetrics metrics = new ServiceCpmMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setValue(this.getValue());
        metrics.setTotal(this.getTotal());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        ServiceCpmMetrics metrics = new ServiceCpmMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setValue(this.getValue());
        metrics.setTotal(this.getTotal());
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public static class Builder
    implements StorageBuilder<ServiceCpmMetrics> {
        public Map<String, Object> data2Map(ServiceCpmMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity_id", storageData.getEntityId());
            map.put("value", storageData.getValue());
            map.put("total", storageData.getTotal());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public ServiceCpmMetrics map2Data(Map<String, Object> dbMap) {
            ServiceCpmMetrics metrics = new ServiceCpmMetrics();
            metrics.setEntityId((String)dbMap.get("entity_id"));
            metrics.setValue(((Number)dbMap.get("value")).longValue());
            metrics.setTotal(((Number)dbMap.get("total")).longValue());
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

