/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.envoyinstancemetric;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.envoyinstancemetric.EnvoyHeapMemoryMaxUsedMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.envoyinstancemetric.EnvoyParentConnectionsUsedMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.envoyinstancemetric.EnvoyTotalConnectionsUsedMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.EnvoyInstanceMetric;

public class EnvoyInstanceMetricDispatcher
implements SourceDispatcher<EnvoyInstanceMetric> {
    public void dispatch(EnvoyInstanceMetric source) {
        this.doEnvoyHeapMemoryMaxUsed(source);
        this.doEnvoyTotalConnectionsUsed(source);
        this.doEnvoyParentConnectionsUsed(source);
    }

    private void doEnvoyHeapMemoryMaxUsed(EnvoyInstanceMetric source) {
        EnvoyHeapMemoryMaxUsedMetrics metrics = new EnvoyHeapMemoryMaxUsedMetrics();
        if (!new EqualMatch().setLeft((Object)source.getMetricName()).setRight((Object)"server.memory_heap_size").match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getValue());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEnvoyTotalConnectionsUsed(EnvoyInstanceMetric source) {
        EnvoyTotalConnectionsUsedMetrics metrics = new EnvoyTotalConnectionsUsedMetrics();
        if (!new EqualMatch().setLeft((Object)source.getMetricName()).setRight((Object)"server.total_connections").match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getValue());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEnvoyParentConnectionsUsed(EnvoyInstanceMetric source) {
        EnvoyParentConnectionsUsedMetrics metrics = new EnvoyParentConnectionsUsedMetrics();
        if (!new EqualMatch().setLeft((Object)source.getMetricName()).setRight((Object)"server.parent_connections").match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.combine(source.getValue());
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

