/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.endpointrelation;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongAvgMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="endpoint_relation_resp_time", scopeId=6, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class EndpointRelationRespTimeMetrics
extends LongAvgMetrics
implements WithMetadata {
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;
    @Column(columnName="service_id")
    private int serviceId;
    @Column(columnName="child_service_id")
    private int childServiceId;
    @Column(columnName="service_instance_id")
    private int serviceInstanceId;
    @Column(columnName="child_service_instance_id")
    private int childServiceInstanceId;

    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.entityId;
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EndpointRelationRespTimeMetrics metrics = (EndpointRelationRespTimeMetrics)((Object)obj);
        if (!this.entityId.equals(metrics.entityId)) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataLongs(this.getSummation());
        remoteBuilder.addDataLongs(this.getValue());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataIntegers(this.getServiceId());
        remoteBuilder.addDataIntegers(this.getChildServiceId());
        remoteBuilder.addDataIntegers(this.getServiceInstanceId());
        remoteBuilder.addDataIntegers(this.getChildServiceInstanceId());
        remoteBuilder.addDataIntegers(this.getCount());
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSummation(remoteData.getDataLongs(0));
        this.setValue(remoteData.getDataLongs(1));
        this.setTimeBucket(remoteData.getDataLongs(2));
        this.setServiceId(remoteData.getDataIntegers(0));
        this.setChildServiceId(remoteData.getDataIntegers(1));
        this.setServiceInstanceId(remoteData.getDataIntegers(2));
        this.setChildServiceInstanceId(remoteData.getDataIntegers(3));
        this.setCount(remoteData.getDataIntegers(4));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("endpoint_relation_resp_time", 6, this.entityId);
    }

    public Metrics toHour() {
        EndpointRelationRespTimeMetrics metrics = new EndpointRelationRespTimeMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setChildServiceId(this.getChildServiceId());
        metrics.setServiceInstanceId(this.getServiceInstanceId());
        metrics.setChildServiceInstanceId(this.getChildServiceInstanceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        EndpointRelationRespTimeMetrics metrics = new EndpointRelationRespTimeMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setChildServiceId(this.getChildServiceId());
        metrics.setServiceInstanceId(this.getServiceInstanceId());
        metrics.setChildServiceInstanceId(this.getChildServiceInstanceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        EndpointRelationRespTimeMetrics metrics = new EndpointRelationRespTimeMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setChildServiceId(this.getChildServiceId());
        metrics.setServiceInstanceId(this.getServiceInstanceId());
        metrics.setChildServiceInstanceId(this.getChildServiceInstanceId());
        metrics.setSummation(this.getSummation());
        metrics.setCount(this.getCount());
        metrics.setValue(this.getValue());
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setChildServiceId(int childServiceId) {
        this.childServiceId = childServiceId;
    }

    public int getChildServiceId() {
        return this.childServiceId;
    }

    public void setServiceInstanceId(int serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    public int getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public void setChildServiceInstanceId(int childServiceInstanceId) {
        this.childServiceInstanceId = childServiceInstanceId;
    }

    public int getChildServiceInstanceId() {
        return this.childServiceInstanceId;
    }

    public static class Builder
    implements StorageBuilder<EndpointRelationRespTimeMetrics> {
        public Map<String, Object> data2Map(EndpointRelationRespTimeMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity_id", storageData.getEntityId());
            map.put("service_id", storageData.getServiceId());
            map.put("child_service_id", storageData.getChildServiceId());
            map.put("service_instance_id", storageData.getServiceInstanceId());
            map.put("child_service_instance_id", storageData.getChildServiceInstanceId());
            map.put("summation", storageData.getSummation());
            map.put("count", storageData.getCount());
            map.put("value", storageData.getValue());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public EndpointRelationRespTimeMetrics map2Data(Map<String, Object> dbMap) {
            EndpointRelationRespTimeMetrics metrics = new EndpointRelationRespTimeMetrics();
            metrics.setEntityId((String)dbMap.get("entity_id"));
            metrics.setServiceId(((Number)dbMap.get("service_id")).intValue());
            metrics.setChildServiceId(((Number)dbMap.get("child_service_id")).intValue());
            metrics.setServiceInstanceId(((Number)dbMap.get("service_instance_id")).intValue());
            metrics.setChildServiceInstanceId(((Number)dbMap.get("child_service_instance_id")).intValue());
            metrics.setSummation(((Number)dbMap.get("summation")).longValue());
            metrics.setCount(((Number)dbMap.get("count")).intValue());
            metrics.setValue(((Number)dbMap.get("value")).longValue());
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

