/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.endpointrelation;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.endpointrelation.EndpointRelationCpmMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpointrelation.EndpointRelationRespTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.EndpointRelation;

public class EndpointRelationDispatcher
implements SourceDispatcher<EndpointRelation> {
    public void dispatch(EndpointRelation source) {
        this.doEndpointRelationCpm(source);
        this.doEndpointRelationRespTime(source);
    }

    private void doEndpointRelationCpm(EndpointRelation source) {
        EndpointRelationCpmMetrics metrics = new EndpointRelationCpmMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setChildServiceId(source.getChildServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.setChildServiceInstanceId(source.getChildServiceInstanceId());
        metrics.combine(1L);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointRelationRespTime(EndpointRelation source) {
        EndpointRelationRespTimeMetrics metrics = new EndpointRelationRespTimeMetrics();
        if (!new EqualMatch().setLeft((Object)source.getDetectPoint()).setRight((Object)DetectPoint.SERVER).match()) {
            return;
        }
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setChildServiceId(source.getChildServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.setChildServiceInstanceId(source.getChildServiceInstanceId());
        metrics.combine(source.getRpcLatency(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

