/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.endpoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueArray;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.P90Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="endpoint_p90", scopeId=3, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class EndpointP90Metrics
extends P90Metrics
implements WithMetadata {
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;
    @Column(columnName="service_id")
    private int serviceId;
    @Column(columnName="service_instance_id")
    private int serviceInstanceId;

    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.entityId;
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EndpointP90Metrics metrics = (EndpointP90Metrics)((Object)obj);
        if (!this.entityId.equals(metrics.entityId)) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataIntegers(this.getServiceId());
        remoteBuilder.addDataIntegers(this.getServiceInstanceId());
        remoteBuilder.addDataIntegers(this.getValue());
        remoteBuilder.addDataIntegers(this.getPrecision());
        this.getDetailGroup().forEach(element -> remoteBuilder.addDataIntLongPairList(element.serialize()));
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setServiceId(remoteData.getDataIntegers(0));
        this.setServiceInstanceId(remoteData.getDataIntegers(1));
        this.setValue(remoteData.getDataIntegers(2));
        this.setPrecision(remoteData.getDataIntegers(3));
        this.setDetailGroup(new IntKeyLongValueArray(30));
        remoteData.getDataIntLongPairListList().forEach(element -> this.getDetailGroup().add((Object)new IntKeyLongValue(element.getKey(), element.getValue())));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("endpoint_p90", 3, this.entityId);
    }

    public Metrics toHour() {
        EndpointP90Metrics metrics = new EndpointP90Metrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setServiceInstanceId(this.getServiceInstanceId());
        metrics.setValue(this.getValue());
        metrics.setPrecision(this.getPrecision());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        EndpointP90Metrics metrics = new EndpointP90Metrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setServiceInstanceId(this.getServiceInstanceId());
        metrics.setValue(this.getValue());
        metrics.setPrecision(this.getPrecision());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        EndpointP90Metrics metrics = new EndpointP90Metrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setServiceId(this.getServiceId());
        metrics.setServiceInstanceId(this.getServiceInstanceId());
        metrics.setValue(this.getValue());
        metrics.setPrecision(this.getPrecision());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceInstanceId(int serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    public int getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static class Builder
    implements StorageBuilder<EndpointP90Metrics> {
        public Map<String, Object> data2Map(EndpointP90Metrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity_id", storageData.getEntityId());
            map.put("service_id", storageData.getServiceId());
            map.put("service_instance_id", storageData.getServiceInstanceId());
            map.put("value", storageData.getValue());
            map.put("precision", storageData.getPrecision());
            map.put("detail_group", storageData.getDetailGroup());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public EndpointP90Metrics map2Data(Map<String, Object> dbMap) {
            EndpointP90Metrics metrics = new EndpointP90Metrics();
            metrics.setEntityId((String)dbMap.get("entity_id"));
            metrics.setServiceId(((Number)dbMap.get("service_id")).intValue());
            metrics.setServiceInstanceId(((Number)dbMap.get("service_instance_id")).intValue());
            metrics.setValue(((Number)dbMap.get("value")).intValue());
            metrics.setPrecision(((Number)dbMap.get("precision")).intValue());
            metrics.setDetailGroup(new IntKeyLongValueArray((String)dbMap.get("detail_group")));
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

