/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.endpoint;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointAvgMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointCpmMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointP50Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointP75Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointP90Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointP95Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointP99Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.endpoint.EndpointSlaMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.Endpoint;

public class EndpointDispatcher
implements SourceDispatcher<Endpoint> {
    public void dispatch(Endpoint source) {
        this.doEndpointCpm(source);
        this.doEndpointAvg(source);
        this.doEndpointSla(source);
        this.doEndpointP99(source);
        this.doEndpointP95(source);
        this.doEndpointP90(source);
        this.doEndpointP75(source);
        this.doEndpointP50(source);
    }

    private void doEndpointCpm(Endpoint source) {
        EndpointCpmMetrics metrics = new EndpointCpmMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(1L);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointAvg(Endpoint source) {
        EndpointAvgMetrics metrics = new EndpointAvgMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(source.getLatency(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointSla(Endpoint source) {
        EndpointSlaMetrics metrics = new EndpointSlaMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(new EqualMatch(), source.isStatus(), true);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointP99(Endpoint source) {
        EndpointP99Metrics metrics = new EndpointP99Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointP95(Endpoint source) {
        EndpointP95Metrics metrics = new EndpointP95Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointP90(Endpoint source) {
        EndpointP90Metrics metrics = new EndpointP90Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointP75(Endpoint source) {
        EndpointP75Metrics metrics = new EndpointP75Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doEndpointP50(Endpoint source) {
        EndpointP50Metrics metrics = new EndpointP50Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.setServiceId(source.getServiceId());
        metrics.setServiceInstanceId(source.getServiceInstanceId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

