/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.PercentMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;

@Stream(name="database_access_sla", scopeId=17, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class DatabaseAccessSlaMetrics
extends PercentMetrics
implements WithMetadata {
    @Column(columnName="entity_id")
    @IDColumn
    private String entityId;

    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        splitJointId = splitJointId + "_" + this.entityId;
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DatabaseAccessSlaMetrics metrics = (DatabaseAccessSlaMetrics)((Object)obj);
        if (!this.entityId.equals(metrics.entityId)) {
            return false;
        }
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataLongs(this.getTotal());
        remoteBuilder.addDataLongs(this.getMatch());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataIntegers(this.getPercentage());
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setEntityId(remoteData.getDataStrings(0));
        this.setTotal(remoteData.getDataLongs(0));
        this.setMatch(remoteData.getDataLongs(1));
        this.setTimeBucket(remoteData.getDataLongs(2));
        this.setPercentage(remoteData.getDataIntegers(0));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("database_access_sla", 17, this.entityId);
    }

    public Metrics toHour() {
        DatabaseAccessSlaMetrics metrics = new DatabaseAccessSlaMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setTotal(this.getTotal());
        metrics.setPercentage(this.getPercentage());
        metrics.setMatch(this.getMatch());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        DatabaseAccessSlaMetrics metrics = new DatabaseAccessSlaMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setTotal(this.getTotal());
        metrics.setPercentage(this.getPercentage());
        metrics.setMatch(this.getMatch());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        DatabaseAccessSlaMetrics metrics = new DatabaseAccessSlaMetrics();
        metrics.setEntityId(this.getEntityId());
        metrics.setTotal(this.getTotal());
        metrics.setPercentage(this.getPercentage());
        metrics.setMatch(this.getMatch());
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public static class Builder
    implements StorageBuilder<DatabaseAccessSlaMetrics> {
        public Map<String, Object> data2Map(DatabaseAccessSlaMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity_id", storageData.getEntityId());
            map.put("total", storageData.getTotal());
            map.put("percentage", storageData.getPercentage());
            map.put("match", storageData.getMatch());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public DatabaseAccessSlaMetrics map2Data(Map<String, Object> dbMap) {
            DatabaseAccessSlaMetrics metrics = new DatabaseAccessSlaMetrics();
            metrics.setEntityId((String)dbMap.get("entity_id"));
            metrics.setTotal(((Number)dbMap.get("total")).longValue());
            metrics.setPercentage(((Number)dbMap.get("percentage")).intValue());
            metrics.setMatch(((Number)dbMap.get("match")).longValue());
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

