/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessCpmMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessP50Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessP75Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessP90Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessP95Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessP99Metrics;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessRespTimeMetrics;
import org.apache.skywalking.oap.server.core.analysis.generated.databaseaccess.DatabaseAccessSlaMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.expression.EqualMatch;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.DatabaseAccess;

public class DatabaseAccessDispatcher
implements SourceDispatcher<DatabaseAccess> {
    public void dispatch(DatabaseAccess source) {
        this.doDatabaseAccessRespTime(source);
        this.doDatabaseAccessSla(source);
        this.doDatabaseAccessCpm(source);
        this.doDatabaseAccessP99(source);
        this.doDatabaseAccessP95(source);
        this.doDatabaseAccessP90(source);
        this.doDatabaseAccessP75(source);
        this.doDatabaseAccessP50(source);
    }

    private void doDatabaseAccessRespTime(DatabaseAccess source) {
        DatabaseAccessRespTimeMetrics metrics = new DatabaseAccessRespTimeMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 1);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doDatabaseAccessSla(DatabaseAccess source) {
        DatabaseAccessSlaMetrics metrics = new DatabaseAccessSlaMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(new EqualMatch(), source.isStatus(), true);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doDatabaseAccessCpm(DatabaseAccess source) {
        DatabaseAccessCpmMetrics metrics = new DatabaseAccessCpmMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(1L);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doDatabaseAccessP99(DatabaseAccess source) {
        DatabaseAccessP99Metrics metrics = new DatabaseAccessP99Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doDatabaseAccessP95(DatabaseAccess source) {
        DatabaseAccessP95Metrics metrics = new DatabaseAccessP95Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doDatabaseAccessP90(DatabaseAccess source) {
        DatabaseAccessP90Metrics metrics = new DatabaseAccessP90Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doDatabaseAccessP75(DatabaseAccess source) {
        DatabaseAccessP75Metrics metrics = new DatabaseAccessP75Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }

    private void doDatabaseAccessP50(DatabaseAccess source) {
        DatabaseAccessP50Metrics metrics = new DatabaseAccessP50Metrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setEntityId(source.getEntityId());
        metrics.combine(source.getLatency(), 10);
        MetricsStreamProcessor.getInstance().in((Metrics)metrics);
    }
}

