/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.all;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueArray;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.P95Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;

@Stream(name="all_p95", scopeId=0, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class AllP95Metrics
extends P95Metrics
implements WithMetadata {
    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AllP95Metrics metrics = (AllP95Metrics)((Object)obj);
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataIntegers(this.getValue());
        remoteBuilder.addDataIntegers(this.getPrecision());
        this.getDetailGroup().forEach(element -> remoteBuilder.addDataIntLongPairList(element.serialize()));
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setValue(remoteData.getDataIntegers(0));
        this.setPrecision(remoteData.getDataIntegers(1));
        this.setDetailGroup(new IntKeyLongValueArray(30));
        remoteData.getDataIntLongPairListList().forEach(element -> this.getDetailGroup().add((Object)new IntKeyLongValue(element.getKey(), element.getValue())));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("all_p95", 0);
    }

    public Metrics toHour() {
        AllP95Metrics metrics = new AllP95Metrics();
        metrics.setValue(this.getValue());
        metrics.setPrecision(this.getPrecision());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        AllP95Metrics metrics = new AllP95Metrics();
        metrics.setValue(this.getValue());
        metrics.setPrecision(this.getPrecision());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        AllP95Metrics metrics = new AllP95Metrics();
        metrics.setValue(this.getValue());
        metrics.setPrecision(this.getPrecision());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public static class Builder
    implements StorageBuilder<AllP95Metrics> {
        public Map<String, Object> data2Map(AllP95Metrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", storageData.getValue());
            map.put("precision", storageData.getPrecision());
            map.put("detail_group", storageData.getDetailGroup());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public AllP95Metrics map2Data(Map<String, Object> dbMap) {
            AllP95Metrics metrics = new AllP95Metrics();
            metrics.setValue(((Number)dbMap.get("value")).intValue());
            metrics.setPrecision(((Number)dbMap.get("precision")).intValue());
            metrics.setDetailGroup(new IntKeyLongValueArray((String)dbMap.get("detail_group")));
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

