/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.generated.all;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueArray;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.ThermodynamicMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;

@Stream(name="all_heatmap", scopeId=0, builder=Builder.class, processor=MetricsStreamProcessor.class)
public class AllHeatmapMetrics
extends ThermodynamicMetrics
implements WithMetadata {
    public String id() {
        String splitJointId = String.valueOf(this.getTimeBucket());
        return splitJointId;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)this.getTimeBucket();
        return result;
    }

    public int remoteHashCode() {
        int result = 17;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AllHeatmapMetrics metrics = (AllHeatmapMetrics)((Object)obj);
        return this.getTimeBucket() == metrics.getTimeBucket();
    }

    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataIntegers(this.getStep());
        remoteBuilder.addDataIntegers(this.getNumOfSteps());
        this.getDetailGroup().forEach(element -> remoteBuilder.addDataIntLongPairList(element.serialize()));
        return remoteBuilder;
    }

    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setStep(remoteData.getDataIntegers(0));
        this.setNumOfSteps(remoteData.getDataIntegers(1));
        this.setDetailGroup(new IntKeyLongValueArray(30));
        remoteData.getDataIntLongPairListList().forEach(element -> this.getDetailGroup().add((Object)new IntKeyLongValue(element.getKey(), element.getValue())));
    }

    public MetricsMetaInfo getMeta() {
        return new MetricsMetaInfo("all_heatmap", 0);
    }

    public Metrics toHour() {
        AllHeatmapMetrics metrics = new AllHeatmapMetrics();
        metrics.setStep(this.getStep());
        metrics.setNumOfSteps(this.getNumOfSteps());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInHour());
        return metrics;
    }

    public Metrics toDay() {
        AllHeatmapMetrics metrics = new AllHeatmapMetrics();
        metrics.setStep(this.getStep());
        metrics.setNumOfSteps(this.getNumOfSteps());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInDay());
        return metrics;
    }

    public Metrics toMonth() {
        AllHeatmapMetrics metrics = new AllHeatmapMetrics();
        metrics.setStep(this.getStep());
        metrics.setNumOfSteps(this.getNumOfSteps());
        IntKeyLongValueArray newValue = new IntKeyLongValueArray();
        newValue.copyFrom((Object)this.getDetailGroup());
        metrics.setDetailGroup(newValue);
        metrics.setTimeBucket(this.toTimeBucketInMonth());
        return metrics;
    }

    public static class Builder
    implements StorageBuilder<AllHeatmapMetrics> {
        public Map<String, Object> data2Map(AllHeatmapMetrics storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("step", storageData.getStep());
            map.put("num_of_steps", storageData.getNumOfSteps());
            map.put("detail_group", storageData.getDetailGroup());
            map.put("time_bucket", storageData.getTimeBucket());
            return map;
        }

        public AllHeatmapMetrics map2Data(Map<String, Object> dbMap) {
            AllHeatmapMetrics metrics = new AllHeatmapMetrics();
            metrics.setStep(((Number)dbMap.get("step")).intValue());
            metrics.setNumOfSteps(((Number)dbMap.get("num_of_steps")).intValue());
            metrics.setDetailGroup(new IntKeyLongValueArray((String)dbMap.get("detail_group")));
            metrics.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            return metrics;
        }
    }
}

