/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.hystrix.v1;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.agent.core.conf.RuntimeContextConfiguration;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.RuntimeContextSnapshot;

public class SWHystrixConcurrencyStrategyWrapper
extends HystrixConcurrencyStrategy {
    private final HystrixConcurrencyStrategy delegate;

    public SWHystrixConcurrencyStrategyWrapper(HystrixConcurrencyStrategy delegate) {
        this.delegate = delegate;
    }

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        Callable delegateCallable = this.delegate != null ? this.delegate.wrapCallable(callable) : super.wrapCallable(callable);
        return new WrappedCallable(ContextManager.getRuntimeContext().capture(), delegateCallable);
    }

    static class WrappedCallable<T>
    implements Callable<T> {
        private final RuntimeContextSnapshot contextSnapshot;
        private final Callable<T> target;

        WrappedCallable(RuntimeContextSnapshot contextSnapshot, Callable<T> target) {
            this.contextSnapshot = contextSnapshot;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            try {
                ContextManager.getRuntimeContext().accept(this.contextSnapshot);
                T t = this.target.call();
                return t;
            }
            finally {
                for (String key : RuntimeContextConfiguration.NEED_PROPAGATE_CONTEXT_KEY) {
                    ContextManager.getRuntimeContext().remove((Object)key);
                }
            }
        }
    }
}

