/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jaeger.elasticsearch;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.jaegertracing.api_v2.Model;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.query.entity.BasicTrace;
import org.apache.skywalking.oap.server.core.query.entity.KeyValue;
import org.apache.skywalking.oap.server.core.query.entity.LogEntity;
import org.apache.skywalking.oap.server.core.query.entity.QueryOrder;
import org.apache.skywalking.oap.server.core.query.entity.Ref;
import org.apache.skywalking.oap.server.core.query.entity.RefType;
import org.apache.skywalking.oap.server.core.query.entity.Span;
import org.apache.skywalking.oap.server.core.query.entity.TraceBrief;
import org.apache.skywalking.oap.server.core.query.entity.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class JaegerTraceQueryEsDAO
extends EsDAO
implements ITraceQueryDAO {
    private ServiceInventoryCache serviceInventoryCache;

    public JaegerTraceQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String endpointName, int serviceId, int serviceInstanceId, int endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        List mustQueryList = boolQueryBuilder.must();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            mustQueryList.add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (minDuration != 0L || maxDuration != 0L) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"latency");
            if (minDuration != 0L) {
                rangeQueryBuilder.gte((Object)minDuration);
            }
            if (maxDuration != 0L) {
                rangeQueryBuilder.lte((Object)maxDuration);
            }
            boolQueryBuilder.must().add(rangeQueryBuilder);
        }
        if (!Strings.isNullOrEmpty((String)endpointName)) {
            mustQueryList.add(QueryBuilders.matchPhraseQuery((String)"endpoint_name", (Object)endpointName));
        }
        if (serviceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (int)serviceId));
        }
        if (serviceInstanceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_instance_id", (int)serviceInstanceId));
        }
        if (endpointId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"endpoint_id", (int)endpointId));
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        }
        switch (traceState) {
            case ERROR: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)1));
                break;
            }
            case SUCCESS: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)0));
            }
        }
        TermsAggregationBuilder builder = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"trace_id").field("trace_id")).size(limit).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"latency").field("latency"))).subAggregation((AggregationBuilder)AggregationBuilders.min((String)"start_time").field("start_time"));
        switch (queryOrder) {
            case BY_START_TIME: {
                builder.order(BucketOrder.aggregation((String)"start_time", (boolean)false));
                break;
            }
            case BY_DURATION: {
                builder.order(BucketOrder.aggregation((String)"latency", (boolean)false));
            }
        }
        sourceBuilder.aggregation((AggregationBuilder)builder);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("jaeger_span", sourceBuilder);
        TraceBrief traceBrief = new TraceBrief();
        Terms terms = (Terms)response.getAggregations().get("trace_id");
        for (Terms.Bucket termsBucket : terms.getBuckets()) {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId(termsBucket.getKeyAsString());
            Min startTime = (Min)termsBucket.getAggregations().get("start_time");
            Max latency = (Max)termsBucket.getAggregations().get("latency");
            basicTrace.setStart(String.valueOf((long)startTime.getValue()));
            basicTrace.getEndpointNames().add("");
            basicTrace.setDuration((int)latency.getValue());
            basicTrace.setError(false);
            basicTrace.getTraceIds().add(termsBucket.getKeyAsString());
            traceBrief.getTraces().add(basicTrace);
        }
        return traceBrief;
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        return Collections.emptyList();
    }

    public List<Span> doFlexibleTraceQuery(String traceId) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        sourceBuilder.sort("start_time", SortOrder.ASC);
        sourceBuilder.size(1000);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("jaeger_span", sourceBuilder);
        ArrayList<Span> spanList = new ArrayList<Span>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            int serviceId = ((Number)searchHit.getSourceAsMap().get("service_id")).intValue();
            long startTime = ((Number)searchHit.getSourceAsMap().get("start_time")).longValue();
            long endTime = ((Number)searchHit.getSourceAsMap().get("end_time")).longValue();
            String dataBinaryBase64 = (String)searchHit.getSourceAsMap().get("data_binary");
            Model.Span jaegerSpan = ((Model.Span.Builder)Model.Span.newBuilder().mergeFrom(Base64.getDecoder().decode(dataBinaryBase64))).build();
            Span swSpan = new Span();
            swSpan.setTraceId(this.format(jaegerSpan.getTraceId()));
            swSpan.setEndpointName(jaegerSpan.getOperationName());
            swSpan.setStartTime(startTime);
            swSpan.setEndTime(endTime);
            jaegerSpan.getTagsList().forEach(keyValue -> {
                String key = keyValue.getKey();
                Model.ValueType valueVType = keyValue.getVType();
                switch (valueVType) {
                    case STRING: {
                        swSpan.getTags().add(new KeyValue(key, keyValue.getVStr()));
                        break;
                    }
                    case INT64: {
                        swSpan.getTags().add(new KeyValue(key, keyValue.getVInt64() + ""));
                        break;
                    }
                    case BOOL: {
                        swSpan.getTags().add(new KeyValue(key, keyValue.getVBool() + ""));
                        break;
                    }
                    case FLOAT64: {
                        swSpan.getTags().add(new KeyValue(key, keyValue.getVFloat64() + ""));
                    }
                }
                swSpan.setType("Local");
                if ("span.kind".equals(key)) {
                    String kind = keyValue.getVStr();
                    if ("server".equals(kind) || "consumer".equals(kind)) {
                        swSpan.setType("Entry");
                    } else if ("client".equals(kind) || "producer".equals(kind)) {
                        swSpan.setType("Exit");
                    }
                }
            });
            jaegerSpan.getLogsList().forEach(log -> {
                LogEntity entity = new LogEntity();
                boolean hasTimestamp = log.hasTimestamp();
                if (hasTimestamp) {
                    long time = Instant.ofEpochSecond(log.getTimestamp().getSeconds(), log.getTimestamp().getNanos()).toEpochMilli();
                    entity.setTime(time);
                }
                log.getFieldsList().forEach(field -> {
                    String key = field.getKey();
                    Model.ValueType valueVType = field.getVType();
                    switch (valueVType) {
                        case STRING: {
                            entity.getData().add(new KeyValue(key, field.getVStr()));
                            break;
                        }
                        case INT64: {
                            entity.getData().add(new KeyValue(key, field.getVInt64() + ""));
                            break;
                        }
                        case BOOL: {
                            entity.getData().add(new KeyValue(key, field.getVBool() + ""));
                            break;
                        }
                        case FLOAT64: {
                            entity.getData().add(new KeyValue(key, field.getVFloat64() + ""));
                        }
                    }
                });
                swSpan.getLogs().add(entity);
            });
            if (serviceId != 0) {
                swSpan.setServiceCode(this.serviceInventoryCache.get(serviceId).getName());
            } else {
                swSpan.setServiceCode("UNKNOWN");
            }
            swSpan.setSpanId(0);
            swSpan.setParentSpanId(-1);
            String spanId = this.id(this.format(jaegerSpan.getTraceId()), this.format(jaegerSpan.getSpanId()));
            swSpan.setSegmentSpanId(spanId);
            swSpan.setSegmentId(spanId);
            List spanReferencesList = jaegerSpan.getReferencesList();
            if (spanReferencesList.size() > 0) {
                spanReferencesList.forEach(jaegerRef -> {
                    Ref ref = new Ref();
                    ref.setTraceId(this.format(jaegerRef.getTraceId()));
                    String parentId = this.id(this.format(jaegerRef.getTraceId()), this.format(jaegerRef.getSpanId()));
                    ref.setParentSegmentId(parentId);
                    ref.setType(RefType.CROSS_PROCESS);
                    ref.setParentSpanId(0);
                    swSpan.getRefs().add(ref);
                    swSpan.setSegmentParentSpanId(parentId);
                });
            } else {
                swSpan.setRoot(true);
                swSpan.setSegmentParentSpanId("");
            }
            spanList.add(swSpan);
        }
        return spanList;
    }

    private String id(String traceId, String spanId) {
        return traceId + "_" + spanId;
    }

    private String format(ByteString bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(bytes.toByteArray());
    }

    public void setServiceInventoryCache(ServiceInventoryCache serviceInventoryCache) {
        this.serviceInventoryCache = serviceInventoryCache;
    }
}

