/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jaeger;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.IDColumn;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

@Stream(name="jaeger_span", scopeId=24, builder=Builder.class, processor=RecordStreamProcessor.class)
public class JaegerSpanRecord
extends Record {
    public static final String INDEX_NAME = "jaeger_span";
    public static final String TRACE_ID = "trace_id";
    public static final String SPAN_ID = "span_id";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ENDPOINT_NAME = "endpoint_name";
    public static final String ENDPOINT_ID = "endpoint_id";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String LATENCY = "latency";
    public static final String IS_ERROR = "is_error";
    public static final String DATA_BINARY = "data_binary";
    public static final String ENCODE = "encode";
    @Column(columnName="trace_id")
    @IDColumn
    private String traceId;
    @Column(columnName="span_id")
    @IDColumn
    private String spanId;
    @Column(columnName="service_id")
    @IDColumn
    private int serviceId;
    @Column(columnName="service_instance_id")
    @IDColumn
    private int serviceInstanceId;
    @Column(columnName="endpoint_name", matchQuery=true)
    @IDColumn
    private String endpointName;
    @Column(columnName="endpoint_id")
    @IDColumn
    private int endpointId;
    @Column(columnName="start_time")
    @IDColumn
    private long startTime;
    @Column(columnName="end_time")
    @IDColumn
    private long endTime;
    @Column(columnName="latency")
    @IDColumn
    private int latency;
    @Column(columnName="is_error")
    @IDColumn
    private int isError;
    @Column(columnName="data_binary")
    @IDColumn
    private byte[] dataBinary;
    @Column(columnName="encode")
    @IDColumn
    private int encode;

    public String id() {
        return this.traceId + "-" + this.spanId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceInstanceId(int serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    public int getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointId(int endpointId) {
        this.endpointId = endpointId;
    }

    public int getEndpointId() {
        return this.endpointId;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setIsError(int isError) {
        this.isError = isError;
    }

    public int getIsError() {
        return this.isError;
    }

    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    public void setEncode(int encode) {
        this.encode = encode;
    }

    public int getEncode() {
        return this.encode;
    }

    public static class Builder
    implements StorageBuilder<JaegerSpanRecord> {
        public Map<String, Object> data2Map(JaegerSpanRecord storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(JaegerSpanRecord.TRACE_ID, storageData.getTraceId());
            map.put(JaegerSpanRecord.SPAN_ID, storageData.getSpanId());
            map.put(JaegerSpanRecord.SERVICE_ID, storageData.getServiceId());
            map.put(JaegerSpanRecord.SERVICE_INSTANCE_ID, storageData.getServiceInstanceId());
            map.put(JaegerSpanRecord.ENDPOINT_NAME, storageData.getEndpointName());
            map.put(JaegerSpanRecord.ENDPOINT_ID, storageData.getEndpointId());
            map.put(JaegerSpanRecord.START_TIME, storageData.getStartTime());
            map.put(JaegerSpanRecord.END_TIME, storageData.getEndTime());
            map.put(JaegerSpanRecord.LATENCY, storageData.getLatency());
            map.put(JaegerSpanRecord.IS_ERROR, storageData.getIsError());
            map.put("time_bucket", storageData.getTimeBucket());
            if (CollectionUtils.isEmpty((byte[])storageData.getDataBinary())) {
                map.put(JaegerSpanRecord.DATA_BINARY, "");
            } else {
                map.put(JaegerSpanRecord.DATA_BINARY, new String(Base64.getEncoder().encode(storageData.getDataBinary())));
            }
            map.put(JaegerSpanRecord.ENCODE, storageData.getEncode());
            return map;
        }

        public JaegerSpanRecord map2Data(Map<String, Object> dbMap) {
            JaegerSpanRecord record = new JaegerSpanRecord();
            record.setTraceId((String)dbMap.get(JaegerSpanRecord.TRACE_ID));
            record.setSpanId((String)dbMap.get(JaegerSpanRecord.SPAN_ID));
            record.setServiceId(((Number)dbMap.get(JaegerSpanRecord.SERVICE_ID)).intValue());
            record.setServiceInstanceId(((Number)dbMap.get(JaegerSpanRecord.SERVICE_INSTANCE_ID)).intValue());
            record.setEndpointName((String)dbMap.get(JaegerSpanRecord.ENDPOINT_NAME));
            record.setEndpointId(((Number)dbMap.get(JaegerSpanRecord.ENDPOINT_ID)).intValue());
            record.setStartTime(((Number)dbMap.get(JaegerSpanRecord.START_TIME)).longValue());
            record.setEndTime(((Number)dbMap.get(JaegerSpanRecord.END_TIME)).longValue());
            record.setLatency(((Number)dbMap.get(JaegerSpanRecord.LATENCY)).intValue());
            record.setIsError(((Number)dbMap.get(JaegerSpanRecord.IS_ERROR)).intValue());
            record.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            if (StringUtil.isEmpty((String)((String)dbMap.get(JaegerSpanRecord.DATA_BINARY)))) {
                record.setDataBinary(new byte[0]);
            } else {
                record.setDataBinary(Base64.getDecoder().decode((String)dbMap.get(JaegerSpanRecord.DATA_BINARY)));
            }
            record.setEncode(((Number)dbMap.get(JaegerSpanRecord.ENCODE)).intValue());
            return record;
        }
    }
}

