/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v6.grpc;

import com.google.gson.JsonObject;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.apache.skywalking.apm.network.common.Commands;
import org.apache.skywalking.apm.network.common.DetectPoint;
import org.apache.skywalking.apm.network.common.KeyIntValuePair;
import org.apache.skywalking.apm.network.common.KeyStringValuePair;
import org.apache.skywalking.apm.network.register.v2.EndpointMapping;
import org.apache.skywalking.apm.network.register.v2.EndpointMappingElement;
import org.apache.skywalking.apm.network.register.v2.Enpoints;
import org.apache.skywalking.apm.network.register.v2.NetAddressMapping;
import org.apache.skywalking.apm.network.register.v2.NetAddresses;
import org.apache.skywalking.apm.network.register.v2.RegisterGrpc;
import org.apache.skywalking.apm.network.register.v2.ServiceAndNetworkAddressMappings;
import org.apache.skywalking.apm.network.register.v2.ServiceInstanceRegisterMapping;
import org.apache.skywalking.apm.network.register.v2.ServiceInstances;
import org.apache.skywalking.apm.network.register.v2.ServiceRegisterMapping;
import org.apache.skywalking.apm.network.register.v2.Services;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.register.service.IEndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.INetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.grpc.InstanceDiscoveryServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterServiceHandler
extends RegisterGrpc.RegisterImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDiscoveryServiceHandler.class);
    private final ServiceInventoryCache serviceInventoryCache;
    private final ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private final IServiceInventoryRegister serviceInventoryRegister;
    private final IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;
    private final IEndpointInventoryRegister inventoryService;
    private final INetworkAddressInventoryRegister networkAddressInventoryRegister;

    public RegisterServiceHandler(ModuleManager moduleManager) {
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
        this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
        this.inventoryService = (IEndpointInventoryRegister)moduleManager.find("core").provider().getService(IEndpointInventoryRegister.class);
        this.networkAddressInventoryRegister = (INetworkAddressInventoryRegister)moduleManager.find("core").provider().getService(INetworkAddressInventoryRegister.class);
    }

    public void doServiceRegister(Services request, StreamObserver<ServiceRegisterMapping> responseObserver) {
        ServiceRegisterMapping.Builder builder = ServiceRegisterMapping.newBuilder();
        request.getServicesList().forEach(service -> {
            int serviceId;
            String serviceName = service.getServiceName();
            if (logger.isDebugEnabled()) {
                logger.debug("Register service, service code: {}", (Object)serviceName);
            }
            if ((serviceId = this.serviceInventoryRegister.getOrCreate(serviceName, null)) != 0) {
                KeyIntValuePair value = KeyIntValuePair.newBuilder().setKey(serviceName).setValue(serviceId).build();
                builder.addServices(value);
            }
        });
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void doServiceInstanceRegister(ServiceInstances request, StreamObserver<ServiceInstanceRegisterMapping> responseObserver) {
        ServiceInstanceRegisterMapping.Builder builder = ServiceInstanceRegisterMapping.newBuilder();
        request.getInstancesList().forEach(instance -> {
            int serviceInstanceId;
            ServiceInventory serviceInventory = this.serviceInventoryCache.get(instance.getServiceId());
            JsonObject instanceProperties = new JsonObject();
            ArrayList<String> ipv4s = new ArrayList<String>();
            for (KeyStringValuePair property : instance.getPropertiesList()) {
                String key;
                switch (key = property.getKey()) {
                    case "host_name": {
                        instanceProperties.addProperty("host_name", property.getValue());
                        break;
                    }
                    case "os_name": {
                        instanceProperties.addProperty("os_name", property.getValue());
                        break;
                    }
                    case "language": {
                        instanceProperties.addProperty("language", property.getValue());
                        break;
                    }
                    case "ipv4": {
                        ipv4s.add(property.getValue());
                        break;
                    }
                    case "process_no": {
                        instanceProperties.addProperty("process_no", property.getValue());
                    }
                }
            }
            instanceProperties.addProperty("ipv4s", ServiceInstanceInventory.PropertyUtil.ipv4sSerialize(ipv4s));
            String instanceName = serviceInventory.getName();
            if (instanceProperties.has("process_no")) {
                instanceName = instanceName + "-pid:" + instanceProperties.get("process_no").getAsString();
            }
            if (instanceProperties.has("host_name")) {
                instanceName = instanceName + "@" + instanceProperties.get("host_name").getAsString();
            }
            if ((serviceInstanceId = this.serviceInstanceInventoryRegister.getOrCreate(instance.getServiceId(), instanceName, instance.getInstanceUUID(), instance.getTime(), instanceProperties)) != 0) {
                logger.info("register service instance id={} [UUID:{}]", (Object)serviceInstanceId, (Object)instance.getInstanceUUID());
                builder.addServiceInstances(KeyIntValuePair.newBuilder().setKey(instance.getInstanceUUID()).setValue(serviceInstanceId));
            }
        });
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void doEndpointRegister(Enpoints request, StreamObserver<EndpointMapping> responseObserver) {
        EndpointMapping.Builder builder = EndpointMapping.newBuilder();
        request.getEndpointsList().forEach(endpoint -> {
            String endpointName;
            int serviceId = endpoint.getServiceId();
            int endpointId = this.inventoryService.getOrCreate(serviceId, endpointName = endpoint.getEndpointName(), org.apache.skywalking.oap.server.core.source.DetectPoint.fromNetworkProtocolDetectPoint((DetectPoint)endpoint.getFrom()));
            if (endpointId != 0) {
                builder.addElements(EndpointMappingElement.newBuilder().setServiceId(serviceId).setEndpointName(endpointName).setEndpointId(endpointId).setFrom(endpoint.getFrom()));
            }
        });
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void doNetworkAddressRegister(NetAddresses request, StreamObserver<NetAddressMapping> responseObserver) {
        NetAddressMapping.Builder builder = NetAddressMapping.newBuilder();
        request.getAddressesList().forEach(networkAddress -> {
            int addressId = this.networkAddressInventoryRegister.getOrCreate(networkAddress, null);
            if (addressId != 0) {
                builder.addAddressIds(KeyIntValuePair.newBuilder().setKey(networkAddress).setValue(addressId));
            }
        });
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void doServiceAndNetworkAddressMappingRegister(ServiceAndNetworkAddressMappings request, StreamObserver<Commands> responseObserver) {
        request.getMappingsList().forEach(mapping -> {
            int serviceId = mapping.getServiceId();
            if (serviceId == 0) {
                int serviceInstanceId = mapping.getServiceInstanceId();
                if (serviceInstanceId == 0) {
                    serviceId = this.serviceInstanceInventoryCache.get(serviceInstanceId).getServiceId();
                } else {
                    return;
                }
            }
            if (serviceId == 0) {
                return;
            }
            int networkAddressId = mapping.getNetworkAddressId();
            if (networkAddressId == 0) {
                String address = mapping.getNetworkAddress();
                if (StringUtil.isEmpty((String)address)) {
                    return;
                }
                networkAddressId = this.networkAddressInventoryRegister.getOrCreate(address, null);
                if (networkAddressId == 0) {
                    return;
                }
            }
            this.serviceInventoryRegister.updateMapping(networkAddressId, serviceId);
        });
        responseObserver.onNext((Object)Commands.getDefaultInstance());
        responseObserver.onCompleted();
    }
}

