/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.oap.server.core.register.service.INetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressRegisterServletHandler
extends JettyJsonHandler {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAddressRegisterServletHandler.class);
    private final INetworkAddressInventoryRegister networkAddressInventoryRegister;
    private Gson gson = new Gson();
    private static final String NETWORK_ADDRESS = "n";
    private static final String ADDRESS_ID = "i";

    public NetworkAddressRegisterServletHandler(ModuleManager moduleManager) {
        this.networkAddressInventoryRegister = (INetworkAddressInventoryRegister)moduleManager.find("core").provider().getService(INetworkAddressInventoryRegister.class);
    }

    public String pathSpec() {
        return "/networkAddress/register";
    }

    protected JsonElement doGet(HttpServletRequest req) {
        throw new UnsupportedOperationException();
    }

    protected JsonElement doPost(HttpServletRequest req) {
        JsonArray responseArray = new JsonArray();
        try {
            JsonArray networkAddresses = (JsonArray)this.gson.fromJson((Reader)req.getReader(), JsonArray.class);
            for (int i = 0; i < networkAddresses.size(); ++i) {
                String networkAddress = networkAddresses.get(i).getAsString();
                if (logger.isDebugEnabled()) {
                    logger.debug("network getAddress register, network getAddress: {}", (Object)networkAddress);
                }
                int addressId = this.networkAddressInventoryRegister.getOrCreate(networkAddress, null);
                JsonObject mapping = new JsonObject();
                mapping.addProperty(ADDRESS_ID, (Number)addressId);
                mapping.addProperty(NETWORK_ADDRESS, networkAddress);
                responseArray.add((JsonElement)mapping);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return responseArray;
    }
}

