/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.jetty.ArgumentsParseException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceHeartBeatServletHandler
extends JettyJsonHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceHeartBeatServletHandler.class);
    private final IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;
    private final ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private final IServiceInventoryRegister serviceInventoryRegister;
    private final Gson gson = new Gson();
    private static final String INSTANCE_ID = "ii";
    private static final String HEARTBEAT_TIME = "ht";

    public InstanceHeartBeatServletHandler(ModuleManager moduleManager) {
        this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
        this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
    }

    public String pathSpec() {
        return "/instance/heartbeat";
    }

    protected JsonElement doGet(HttpServletRequest req) throws ArgumentsParseException {
        throw new UnsupportedOperationException();
    }

    protected JsonElement doPost(HttpServletRequest req) throws ArgumentsParseException, IOException {
        JsonObject responseJson = new JsonObject();
        try {
            JsonObject heartBeat = (JsonObject)this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
            int instanceId = heartBeat.get(INSTANCE_ID).getAsInt();
            long heartBeatTime = heartBeat.get(HEARTBEAT_TIME).getAsLong();
            this.serviceInstanceInventoryRegister.heartbeat(instanceId, heartBeatTime);
            ServiceInstanceInventory serviceInstanceInventory = this.serviceInstanceInventoryCache.get(instanceId);
            if (Objects.nonNull(serviceInstanceInventory)) {
                this.serviceInventoryRegister.heartbeat(serviceInstanceInventory.getServiceId(), heartBeatTime);
            } else {
                logger.warn("Can't found service by service instance id from cache, service instance id is: {}", (Object)instanceId);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return responseJson;
    }
}

