/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.grpc;

import io.grpc.stub.StreamObserver;
import java.util.List;
import org.apache.skywalking.apm.network.language.agent.ServiceNameCollection;
import org.apache.skywalking.apm.network.language.agent.ServiceNameDiscoveryServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.ServiceNameElement;
import org.apache.skywalking.apm.network.language.agent.ServiceNameMappingCollection;
import org.apache.skywalking.apm.network.language.agent.ServiceNameMappingElement;
import org.apache.skywalking.apm.network.language.agent.SpanType;
import org.apache.skywalking.oap.server.core.register.service.IEndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNameDiscoveryHandler
extends ServiceNameDiscoveryServiceGrpc.ServiceNameDiscoveryServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceNameDiscoveryHandler.class);
    private final IEndpointInventoryRegister inventoryService;

    public ServiceNameDiscoveryHandler(ModuleManager moduleManager) {
        this.inventoryService = (IEndpointInventoryRegister)moduleManager.find("core").provider().getService(IEndpointInventoryRegister.class);
    }

    public void discovery(ServiceNameCollection request, StreamObserver<ServiceNameMappingCollection> responseObserver) {
        List serviceNameElementList = request.getElementsList();
        ServiceNameMappingCollection.Builder builder = ServiceNameMappingCollection.newBuilder();
        for (ServiceNameElement serviceNameElement : serviceNameElementList) {
            String endpointName;
            int serviceId = serviceNameElement.getApplicationId();
            int endpointId = this.inventoryService.getOrCreate(serviceId, endpointName = serviceNameElement.getServiceName(), DetectPoint.fromSpanType((SpanType)serviceNameElement.getSrcSpanType()));
            if (endpointId == 0) continue;
            ServiceNameMappingElement.Builder mappingElement = ServiceNameMappingElement.newBuilder();
            mappingElement.setServiceId(endpointId);
            mappingElement.setElement(serviceNameElement);
            builder.addElements(mappingElement);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }
}

