/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.grpc;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.network.language.agent.ApplicationInstance;
import org.apache.skywalking.apm.network.language.agent.ApplicationInstanceHeartbeat;
import org.apache.skywalking.apm.network.language.agent.ApplicationInstanceMapping;
import org.apache.skywalking.apm.network.language.agent.Downstream;
import org.apache.skywalking.apm.network.language.agent.InstanceDiscoveryServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.OSInfo;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceDiscoveryServiceHandler
extends InstanceDiscoveryServiceGrpc.InstanceDiscoveryServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDiscoveryServiceHandler.class);
    private final ServiceInventoryCache serviceInventoryCache;
    private final ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private final IServiceInventoryRegister serviceInventoryRegister;
    private final IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;

    public InstanceDiscoveryServiceHandler(ModuleManager moduleManager) {
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
        this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
    }

    public void registerInstance(ApplicationInstance request, StreamObserver<ApplicationInstanceMapping> responseObserver) {
        OSInfo osinfo = request.getOsinfo();
        JsonObject instanceProperties = new JsonObject();
        instanceProperties.addProperty("host_name", osinfo.getHostname());
        instanceProperties.addProperty("os_name", osinfo.getOsName());
        instanceProperties.addProperty("process_no", osinfo.getProcessNo() + "");
        instanceProperties.addProperty("ipv4s", ServiceInstanceInventory.PropertyUtil.ipv4sSerialize((List)osinfo.getIpv4SList()));
        ServiceInventory serviceInventory = this.serviceInventoryCache.get(request.getApplicationId());
        String instanceName = serviceInventory.getName();
        if (osinfo.getProcessNo() != 0) {
            instanceName = instanceName + "-pid:" + osinfo.getProcessNo();
        }
        if (!Strings.isNullOrEmpty((String)osinfo.getHostname())) {
            instanceName = instanceName + "@" + osinfo.getHostname();
        }
        int serviceInstanceId = this.serviceInstanceInventoryRegister.getOrCreate(request.getApplicationId(), instanceName, request.getAgentUUID(), request.getRegisterTime(), instanceProperties);
        ApplicationInstanceMapping.Builder builder = ApplicationInstanceMapping.newBuilder();
        builder.setApplicationId(request.getApplicationId());
        builder.setApplicationInstanceId(serviceInstanceId);
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void heartbeat(ApplicationInstanceHeartbeat request, StreamObserver<Downstream> responseObserver) {
        int serviceInstanceId = request.getApplicationInstanceId();
        long heartBeatTime = request.getHeartbeatTime();
        this.serviceInstanceInventoryRegister.heartbeat(serviceInstanceId, heartBeatTime);
        ServiceInstanceInventory serviceInstanceInventory = this.serviceInstanceInventoryCache.get(serviceInstanceId);
        if (Objects.nonNull(serviceInstanceInventory)) {
            this.serviceInventoryRegister.heartbeat(serviceInstanceInventory.getServiceId(), heartBeatTime);
        } else {
            logger.warn("Can't found service by service instance id from cache, service instance id is: {}", (Object)serviceInstanceId);
        }
        responseObserver.onNext((Object)Downstream.getDefaultInstance());
        responseObserver.onCompleted();
    }
}

