/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.grpc;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.language.agent.Application;
import org.apache.skywalking.apm.network.language.agent.ApplicationMapping;
import org.apache.skywalking.apm.network.language.agent.ApplicationRegisterServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.KeyWithIntegerValue;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRegisterHandler
extends ApplicationRegisterServiceGrpc.ApplicationRegisterServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationRegisterHandler.class);
    private final IServiceInventoryRegister serviceInventoryRegister;

    public ApplicationRegisterHandler(ModuleManager moduleManager) {
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
    }

    public void applicationCodeRegister(Application request, StreamObserver<ApplicationMapping> responseObserver) {
        if (logger.isDebugEnabled()) {
            logger.debug("Register application, application code: {}", (Object)request.getApplicationCode());
        }
        ApplicationMapping.Builder builder = ApplicationMapping.newBuilder();
        String serviceName = request.getApplicationCode();
        int serviceId = this.serviceInventoryRegister.getOrCreate(serviceName, null);
        if (serviceId != 0) {
            KeyWithIntegerValue value = KeyWithIntegerValue.newBuilder().setKey(serviceName).setValue(serviceId).build();
            builder.setApplication(value);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }
}

