/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v2;

import io.netty.handler.codec.http.HttpHeaders;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientRequest;

public class HttpClientOperationsSendInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpClientRequest request = (HttpClientRequest)objInst;
        EnhancedInstance instance = (EnhancedInstance)request;
        HttpHeaders header = request.requestHeaders();
        ChannelOperations channelOpt = (ChannelOperations)objInst;
        InetSocketAddress remote = (InetSocketAddress)channelOpt.channel().remoteAddress();
        String peer = remote.getHostName() + ":" + remote.getPort();
        AbstractSpan span = ContextManager.createExitSpan((String)HttpClientOperationsSendInterceptor.toPath(request.uri()), (String)peer);
        ContextSnapshot snapshot = (ContextSnapshot)instance.getSkyWalkingDynamicField();
        ContextManager.continued((ContextSnapshot)snapshot);
        ContextCarrier contextCarrier = new ContextCarrier();
        ContextManager.inject((ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.SPRING_CLOUD_GATEWAY);
        Tags.URL.set(span, peer + request.uri());
        Tags.HTTP.METHOD.set(span, request.method().name());
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            header.set(next.getHeadKey(), (Object)next.getHeadValue());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }

    private static String toPath(String uri) {
        int index = uri.indexOf("?");
        if (index > -1) {
            return uri.substring(0, index);
        }
        return uri;
    }
}

