/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.httpasyncclient.v4.wrapper;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.plugin.httpasyncclient.v4.SessionRequestCompleteInterceptor;

public class HttpAsyncResponseConsumerWrapper<T>
implements HttpAsyncResponseConsumer<T> {
    private HttpAsyncResponseConsumer<T> consumer;

    public HttpAsyncResponseConsumerWrapper(HttpAsyncResponseConsumer<T> consumer) {
        this.consumer = consumer;
    }

    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        if (ContextManager.isActive()) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode > 400) {
                AbstractSpan span = ContextManager.activeSpan();
                Tags.STATUS_CODE.set(span, String.valueOf(statusCode));
            }
            ContextManager.stopSpan();
        }
        this.consumer.responseReceived(response);
    }

    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.consumer.consumeContent(decoder, ioctrl);
    }

    public void responseCompleted(HttpContext context) {
        this.consumer.responseCompleted(context);
    }

    public void failed(Exception ex) {
        SessionRequestCompleteInterceptor.CONTEXT_LOCAL.remove();
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().errorOccurred().log((Throwable)ex);
            ContextManager.stopSpan();
        }
        this.consumer.failed(ex);
    }

    public Exception getException() {
        return this.consumer.getException();
    }

    public T getResult() {
        return (T)this.consumer.getResult();
    }

    public boolean isDone() {
        return this.consumer.isDone();
    }

    public void close() throws IOException {
        this.consumer.close();
    }

    public boolean cancel() {
        SessionRequestCompleteInterceptor.CONTEXT_LOCAL.remove();
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().errorOccurred();
            ContextManager.stopSpan();
        }
        return this.consumer.cancel();
    }
}

