/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1StatefulSet;
import io.kubernetes.client.models.V1StatefulSetFluent;
import io.kubernetes.client.models.V1StatefulSetSpec;
import io.kubernetes.client.models.V1StatefulSetSpecBuilder;
import io.kubernetes.client.models.V1StatefulSetSpecFluentImpl;
import io.kubernetes.client.models.V1StatefulSetStatus;
import io.kubernetes.client.models.V1StatefulSetStatusBuilder;
import io.kubernetes.client.models.V1StatefulSetStatusFluentImpl;

public class V1StatefulSetFluentImpl<A extends V1StatefulSetFluent<A>>
extends BaseFluent<A>
implements V1StatefulSetFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1StatefulSetSpecBuilder spec;
    private V1StatefulSetStatusBuilder status;

    public V1StatefulSetFluentImpl() {
    }

    public V1StatefulSetFluentImpl(V1StatefulSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1StatefulSetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1StatefulSetFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1StatefulSetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1StatefulSetFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1StatefulSetFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1StatefulSetSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1StatefulSetSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1StatefulSetSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new V1StatefulSetSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1StatefulSetFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1StatefulSetFluent.SpecNested<A> withNewSpecLike(V1StatefulSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1StatefulSetFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1StatefulSetFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1StatefulSetSpecBuilder().build());
    }

    @Override
    public V1StatefulSetFluent.SpecNested<A> editOrNewSpecLike(V1StatefulSetSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1StatefulSetStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1StatefulSetStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1StatefulSetStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new V1StatefulSetStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1StatefulSetFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1StatefulSetFluent.StatusNested<A> withNewStatusLike(V1StatefulSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1StatefulSetFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1StatefulSetFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1StatefulSetStatusBuilder().build());
    }

    @Override
    public V1StatefulSetFluent.StatusNested<A> editOrNewStatusLike(V1StatefulSetStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StatefulSetFluentImpl that = (V1StatefulSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends V1StatefulSetStatusFluentImpl<V1StatefulSetFluent.StatusNested<N>>
    implements V1StatefulSetFluent.StatusNested<N>,
    Nested<N> {
        private final V1StatefulSetStatusBuilder builder;

        StatusNestedImpl(V1StatefulSetStatus item) {
            this.builder = new V1StatefulSetStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1StatefulSetStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends V1StatefulSetSpecFluentImpl<V1StatefulSetFluent.SpecNested<N>>
    implements V1StatefulSetFluent.SpecNested<N>,
    Nested<N> {
        private final V1StatefulSetSpecBuilder builder;

        SpecNestedImpl(V1StatefulSetSpec item) {
            this.builder = new V1StatefulSetSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1StatefulSetSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1StatefulSetFluent.MetadataNested<N>>
    implements V1StatefulSetFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

