/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookCallback
implements AlarmCallback {
    private static final Logger logger = LoggerFactory.getLogger(WebhookCallback.class);
    private static final int HTTP_CONNECT_TIMEOUT = 1000;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 1000;
    private static final int HTTP_SOCKET_TIMEOUT = 10000;
    private List<String> remoteEndpoints;
    private RequestConfig requestConfig;
    private Gson gson = new Gson();

    public WebhookCallback(List<String> remoteEndpoints) {
        this.remoteEndpoints = remoteEndpoints;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAlarm(List<AlarmMessage> alarmMessage) {
        if (this.remoteEndpoints.size() == 0) {
            return;
        }
        CloseableHttpClient httpClient = HttpClients.custom().build();
        try {
            this.remoteEndpoints.forEach(url -> {
                HttpPost post = new HttpPost(url);
                post.setConfig(this.requestConfig);
                post.setHeader("Accept", "application/json");
                post.setHeader("Content-type", "application/json");
                StringEntity entity = null;
                try {
                    entity = new StringEntity(this.gson.toJson((Object)alarmMessage));
                    post.setEntity((HttpEntity)entity);
                    CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (statusLine != null && statusLine.getStatusCode() != 200) {
                        logger.error("send alarm to " + url + " failure. Response code: " + statusLine.getStatusCode());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.error("Alarm to JSON error, " + e.getMessage(), (Throwable)e);
                }
                catch (ClientProtocolException e) {
                    logger.error("send alarm to " + url + " failure.", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("send alarm to " + url + " failure.", (Throwable)e);
                }
            });
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

