/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import org.apache.skywalking.oap.server.core.alarm.provider.MetricsValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threshold {
    private static final Logger logger = LoggerFactory.getLogger(Threshold.class);
    private String alarmRuleName;
    private final String threshold;
    private int intThreshold;
    private double doubleThreadhold;
    private long longThreshold;

    public Threshold(String alarmRuleName, String threshold) {
        this.alarmRuleName = alarmRuleName;
        this.threshold = threshold;
    }

    public int getIntThreshold() {
        return this.intThreshold;
    }

    public double getDoubleThreadhold() {
        return this.doubleThreadhold;
    }

    public long getLongThreshold() {
        return this.longThreshold;
    }

    public void setType(MetricsValueType type) {
        try {
            switch (type) {
                case INT: {
                    this.intThreshold = Integer.parseInt(this.threshold);
                    break;
                }
                case LONG: {
                    this.longThreshold = Long.parseLong(this.threshold);
                    break;
                }
                case DOUBLE: {
                    this.doubleThreadhold = Double.parseDouble(this.threshold);
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warn("Alarm rule {} threshold doesn't match the metrics type, expected type: {}", (Object)this.alarmRuleName, (Object)type);
        }
    }
}

