/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.MetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmMessageFormatter;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.MetricsValueType;
import org.apache.skywalking.oap.server.core.alarm.provider.OP;
import org.apache.skywalking.oap.server.core.alarm.provider.Threshold;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningRule {
    private static final Logger logger = LoggerFactory.getLogger(RunningRule.class);
    private static DateTimeFormatter TIME_BUCKET_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
    private String ruleName;
    private int period;
    private String metricsName;
    private final Threshold threshold;
    private final OP op;
    private final int countThreshold;
    private final int silencePeriod;
    private Map<MetaInAlarm, Window> windows;
    private volatile MetricsValueType valueType;
    private int targetScopeId;
    private List<String> includeNames;
    private AlarmMessageFormatter formatter;

    public RunningRule(AlarmRule alarmRule) {
        this.metricsName = alarmRule.getMetricsName();
        this.ruleName = alarmRule.getAlarmRuleName();
        this.windows = new ConcurrentHashMap<MetaInAlarm, Window>();
        this.period = alarmRule.getPeriod();
        this.threshold = new Threshold(alarmRule.getAlarmRuleName(), alarmRule.getThreshold());
        this.op = OP.get(alarmRule.getOp());
        this.countThreshold = alarmRule.getCount();
        this.silencePeriod = alarmRule.getSilencePeriod();
        this.includeNames = alarmRule.getIncludeNames();
        this.formatter = new AlarmMessageFormatter(alarmRule.getMessage());
    }

    public void in(MetaInAlarm meta, Metrics metrics) {
        if (!meta.getMetricsName().equals(this.metricsName)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(this.includeNames) && !this.includeNames.contains(meta.getName())) {
            return;
        }
        if (this.valueType == null) {
            if (metrics instanceof LongValueHolder) {
                this.valueType = MetricsValueType.LONG;
                this.threshold.setType(MetricsValueType.LONG);
            } else if (metrics instanceof IntValueHolder) {
                this.valueType = MetricsValueType.INT;
                this.threshold.setType(MetricsValueType.INT);
            } else if (metrics instanceof DoubleValueHolder) {
                this.valueType = MetricsValueType.DOUBLE;
                this.threshold.setType(MetricsValueType.DOUBLE);
            } else {
                return;
            }
            this.targetScopeId = meta.getScopeId();
        }
        if (this.valueType != null) {
            Window window = this.windows.get(meta);
            if (window == null) {
                window = new Window(this.period);
                LocalDateTime timebucket = TIME_BUCKET_FORMATTER.parseLocalDateTime(metrics.getTimeBucket() + "");
                window.moveTo(timebucket);
                this.windows.put(meta, window);
            }
            window.add(metrics);
        }
    }

    public void moveTo(LocalDateTime targetTime) {
        this.windows.values().forEach(window -> window.moveTo(targetTime));
    }

    public List<AlarmMessage> check() {
        ArrayList<AlarmMessage> alarmMessageList = new ArrayList<AlarmMessage>(30);
        this.windows.entrySet().forEach(entry -> {
            MetaInAlarm meta = (MetaInAlarm)entry.getKey();
            Window window = (Window)entry.getValue();
            AlarmMessage alarmMessage = window.checkAlarm();
            if (alarmMessage != AlarmMessage.NONE) {
                alarmMessage.setScopeId(meta.getScopeId());
                alarmMessage.setName(meta.getName());
                alarmMessage.setId0(meta.getId0());
                alarmMessage.setId1(meta.getId1());
                alarmMessage.setAlarmMessage(this.formatter.format(meta));
                alarmMessage.setStartTime(System.currentTimeMillis());
                alarmMessageList.add(alarmMessage);
            }
        });
        return alarmMessageList;
    }

    public class Window {
        private LocalDateTime endTime;
        private int period;
        private int counter;
        private int silenceCountdown;
        private LinkedList<Metrics> values;
        private ReentrantLock lock = new ReentrantLock();

        public Window(int period) {
            this.period = period;
            this.silenceCountdown = -1;
            this.counter = 0;
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveTo(LocalDateTime current) {
            this.lock.lock();
            try {
                if (this.endTime == null) {
                    this.init();
                    this.endTime = current;
                } else {
                    int minutes = Minutes.minutesBetween((ReadablePartial)this.endTime, (ReadablePartial)current).getMinutes();
                    if (minutes <= 0) {
                        return;
                    }
                    if (minutes > this.values.size()) {
                        this.init();
                    } else {
                        for (int i = 0; i < minutes; ++i) {
                            this.values.removeFirst();
                            this.values.addLast(null);
                        }
                    }
                    this.endTime = current;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Metrics metrics) {
            long bucket = metrics.getTimeBucket();
            LocalDateTime timebucket = TIME_BUCKET_FORMATTER.parseLocalDateTime(bucket + "");
            int minutes = Minutes.minutesBetween((ReadablePartial)timebucket, (ReadablePartial)this.endTime).getMinutes();
            if (minutes == -1) {
                this.moveTo(timebucket);
            }
            this.lock.lock();
            try {
                if (minutes < 0) {
                    this.moveTo(timebucket);
                    minutes = 0;
                }
                if (minutes >= this.values.size()) {
                    return;
                }
                this.values.set(this.values.size() - minutes - 1, metrics);
            }
            finally {
                this.lock.unlock();
            }
        }

        public AlarmMessage checkAlarm() {
            if (this.isMatch()) {
                ++this.counter;
                if (this.counter >= RunningRule.this.countThreshold && this.silenceCountdown < 1) {
                    this.silenceCountdown = RunningRule.this.silencePeriod;
                    AlarmMessage message = new AlarmMessage();
                    return message;
                }
                --this.silenceCountdown;
            } else {
                --this.silenceCountdown;
                if (this.counter > 0) {
                    --this.counter;
                }
            }
            return AlarmMessage.NONE;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean isMatch() {
            int matchCount = 0;
            block20: for (Metrics metrics : this.values) {
                if (metrics == null) continue;
                switch (RunningRule.this.valueType) {
                    case LONG: {
                        long lvalue = ((LongValueHolder)metrics).getValue();
                        long lexpected = RunningRule.this.threshold.getLongThreshold();
                        switch (RunningRule.this.op) {
                            case GREATER: {
                                if (lvalue <= lexpected) continue block20;
                                ++matchCount;
                                break;
                            }
                            case LESS: {
                                if (lvalue >= lexpected) continue block20;
                                ++matchCount;
                                break;
                            }
                            case EQUAL: {
                                if (lvalue != lexpected) continue block20;
                                ++matchCount;
                                continue block20;
                            }
                        }
                        break;
                    }
                    case INT: {
                        int ivalue = ((IntValueHolder)metrics).getValue();
                        int iexpected = RunningRule.this.threshold.getIntThreshold();
                        switch (RunningRule.this.op) {
                            case LESS: {
                                if (ivalue >= iexpected) continue block20;
                                ++matchCount;
                                break;
                            }
                            case GREATER: {
                                if (ivalue <= iexpected) continue block20;
                                ++matchCount;
                                break;
                            }
                            case EQUAL: {
                                if (ivalue != iexpected) continue block20;
                                ++matchCount;
                                continue block20;
                            }
                        }
                        break;
                    }
                    case DOUBLE: {
                        double dvalue = ((DoubleValueHolder)metrics).getValue();
                        double dexpected = RunningRule.this.threshold.getDoubleThreadhold();
                        switch (RunningRule.this.op) {
                            case EQUAL: {
                                if (dvalue != dexpected) break;
                                ++matchCount;
                                break;
                            }
                            case GREATER: {
                                if (!(dvalue > dexpected)) break;
                                ++matchCount;
                                break;
                            }
                            case LESS: {
                                if (!(dvalue < dexpected)) break;
                                ++matchCount;
                            }
                        }
                        continue block20;
                    }
                }
            }
            if (matchCount < RunningRule.this.countThreshold) return false;
            return true;
        }

        private void init() {
            this.values = new LinkedList();
            for (int i = 0; i < this.period; ++i) {
                this.values.add(null);
            }
        }
    }
}

