/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.yaml.snakeyaml.Yaml;

public class RulesReader {
    private Map yamlData;

    public RulesReader(InputStream inputStream) {
        Yaml yaml = new Yaml();
        this.yamlData = (Map)yaml.loadAs(inputStream, Map.class);
    }

    public RulesReader(Reader io) {
        Yaml yaml = new Yaml();
        this.yamlData = (Map)yaml.loadAs(io, Map.class);
    }

    public Rules readRules() {
        Rules rules = new Rules();
        if (Objects.nonNull(this.yamlData)) {
            List webhooks;
            Map rulesData = (Map)this.yamlData.get("rules");
            if (rulesData != null) {
                rules.setRules(new ArrayList<AlarmRule>());
                rulesData.forEach((k, v) -> {
                    if (((String)k).endsWith("_rule")) {
                        AlarmRule alarmRule = new AlarmRule();
                        alarmRule.setAlarmRuleName((String)k);
                        Map settings = (Map)v;
                        Object metricsName = settings.get("metrics-name");
                        if (metricsName == null) {
                            throw new IllegalArgumentException("metrics-name can't be null");
                        }
                        alarmRule.setMetricsName((String)metricsName);
                        alarmRule.setIncludeNames(settings.getOrDefault("include-names", new ArrayList(0)));
                        alarmRule.setThreshold(settings.get("threshold").toString());
                        alarmRule.setOp((String)settings.get("op"));
                        alarmRule.setPeriod(settings.getOrDefault("period", 1));
                        alarmRule.setCount(settings.getOrDefault("count", 1));
                        alarmRule.setSilencePeriod(settings.getOrDefault("silence-period", -1));
                        alarmRule.setMessage(settings.getOrDefault("message", "Alarm caused by Rule " + alarmRule.getAlarmRuleName()));
                        rules.getRules().add(alarmRule);
                    }
                });
            }
            if ((webhooks = (List)this.yamlData.get("webhooks")) != null) {
                rules.setWebhooks(new ArrayList<String>());
                webhooks.forEach(url -> rules.getWebhooks().add((String)url));
            }
        }
        return rules;
    }
}

