/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.EndpointMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.MetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.MetricsNotify;
import org.apache.skywalking.oap.server.core.alarm.ServiceInstanceMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.ServiceMetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmCore;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.apache.skywalking.oap.server.core.alarm.provider.WebhookCallback;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.analysis.metrics.WithMetadata;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.EndpointInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class NotifyHandler
implements MetricsNotify {
    private ServiceInventoryCache serviceInventoryCache;
    private ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;
    private final AlarmCore core;
    private final Rules rules;

    public NotifyHandler(Rules rules) {
        this.rules = rules;
        this.core = new AlarmCore(rules);
    }

    public void notify(Metrics metrics) {
        ServiceMetaInAlarm metaInAlarm;
        WithMetadata withMetadata = (WithMetadata)metrics;
        MetricsMetaInfo meta = withMetadata.getMeta();
        int scope = meta.getScope();
        if (!(DefaultScopeDefine.inServiceCatalog((int)scope) || DefaultScopeDefine.inServiceInstanceCatalog((int)scope) || DefaultScopeDefine.inEndpointCatalog((int)scope))) {
            return;
        }
        if (DefaultScopeDefine.inServiceCatalog((int)scope)) {
            int serviceId = Integer.parseInt(meta.getId());
            ServiceInventory serviceInventory = this.serviceInventoryCache.get(serviceId);
            ServiceMetaInAlarm serviceMetaInAlarm = new ServiceMetaInAlarm();
            serviceMetaInAlarm.setMetricsName(meta.getMetricsName());
            serviceMetaInAlarm.setId(serviceId);
            serviceMetaInAlarm.setName(serviceInventory.getName());
            metaInAlarm = serviceMetaInAlarm;
        } else if (DefaultScopeDefine.inServiceInstanceCatalog((int)scope)) {
            int serviceInstanceId = Integer.parseInt(meta.getId());
            ServiceInstanceInventory serviceInstanceInventory = this.serviceInstanceInventoryCache.get(serviceInstanceId);
            ServiceInstanceMetaInAlarm instanceMetaInAlarm = new ServiceInstanceMetaInAlarm();
            instanceMetaInAlarm.setMetricsName(meta.getMetricsName());
            instanceMetaInAlarm.setId(serviceInstanceId);
            instanceMetaInAlarm.setName(serviceInstanceInventory.getName());
            metaInAlarm = instanceMetaInAlarm;
        } else if (DefaultScopeDefine.inEndpointCatalog((int)scope)) {
            int endpointId = Integer.parseInt(meta.getId());
            EndpointInventory endpointInventory = this.endpointInventoryCache.get(endpointId);
            EndpointMetaInAlarm endpointMetaInAlarm = new EndpointMetaInAlarm();
            endpointMetaInAlarm.setMetricsName(meta.getMetricsName());
            endpointMetaInAlarm.setId(endpointId);
            int serviceId = endpointInventory.getServiceId();
            ServiceInventory serviceInventory = this.serviceInventoryCache.get(serviceId);
            String textName = endpointInventory.getName() + " in " + serviceInventory.getName();
            endpointMetaInAlarm.setName(textName);
            metaInAlarm = endpointMetaInAlarm;
        } else {
            return;
        }
        List<RunningRule> runningRules = this.core.findRunningRule(meta.getMetricsName());
        if (runningRules == null) {
            return;
        }
        runningRules.forEach(arg_0 -> NotifyHandler.lambda$notify$0((MetaInAlarm)metaInAlarm, metrics, arg_0));
    }

    public void init(AlarmCallback ... callbacks) {
        ArrayList<AlarmCallback> allCallbacks = new ArrayList<AlarmCallback>();
        for (AlarmCallback callback : callbacks) {
            allCallbacks.add(callback);
        }
        allCallbacks.add(new WebhookCallback(this.rules.getWebhooks()));
        this.core.start(allCallbacks);
    }

    public void initCache(ModuleManager moduleManager) {
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        this.endpointInventoryCache = (EndpointInventoryCache)moduleManager.find("core").provider().getService(EndpointInventoryCache.class);
    }

    private static /* synthetic */ void lambda$notify$0(MetaInAlarm metaInAlarm, Metrics metrics, RunningRule rule) {
        rule.in(metaInAlarm, metrics);
    }
}

