/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.io.FileNotFoundException;
import java.io.Reader;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmModule;
import org.apache.skywalking.oap.server.core.alarm.AlarmStandardPersistence;
import org.apache.skywalking.oap.server.core.alarm.MetricsNotify;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.NotifyHandler;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.RulesReader;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;

public class AlarmModuleProvider
extends ModuleProvider {
    private NotifyHandler notifyHandler;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return AlarmModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return new AlarmSettings();
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        Reader applicationReader;
        try {
            applicationReader = ResourceUtils.read((String)"alarm-settings.yml");
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("can't load alarm-settings.yml", (Throwable)e);
        }
        RulesReader reader = new RulesReader(applicationReader);
        Rules rules = reader.readRules();
        this.notifyHandler = new NotifyHandler(rules);
        this.notifyHandler.init(new AlarmCallback[]{new AlarmStandardPersistence()});
        this.registerServiceImplementation(MetricsNotify.class, (Service)this.notifyHandler);
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        this.notifyHandler.initCache(this.getManager());
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

