/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmCore {
    private static final Logger logger = LoggerFactory.getLogger(AlarmCore.class);
    private Map<String, List<RunningRule>> runningContext = new HashMap<String, List<RunningRule>>();
    private LocalDateTime lastExecuteTime;

    AlarmCore(Rules rules) {
        rules.getRules().forEach(rule -> {
            RunningRule runningRule = new RunningRule((AlarmRule)rule);
            String metricsName = rule.getMetricsName();
            List runningRules = this.runningContext.computeIfAbsent(metricsName, key -> new ArrayList());
            runningRules.add(runningRule);
        });
    }

    public List<RunningRule> findRunningRule(String metricsName) {
        return this.runningContext.get(metricsName);
    }

    public void start(List<AlarmCallback> allCallbacks) {
        LocalDateTime now;
        this.lastExecuteTime = now = LocalDateTime.now();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                ArrayList alarmMessageList = new ArrayList(30);
                LocalDateTime checkTime = LocalDateTime.now();
                int minutes = Minutes.minutesBetween((ReadablePartial)this.lastExecuteTime, (ReadablePartial)checkTime).getMinutes();
                boolean[] hasExecute = new boolean[]{false};
                this.runningContext.values().forEach(ruleList -> ruleList.forEach(runningRule -> {
                    if (minutes > 0) {
                        runningRule.moveTo(checkTime);
                        if (checkTime.getSecondOfMinute() > 15) {
                            hasExecute[0] = true;
                            alarmMessageList.addAll(runningRule.check());
                        }
                    }
                }));
                if (hasExecute[0]) {
                    this.lastExecuteTime = checkTime.minusSeconds(checkTime.getSecondOfMinute());
                }
                if (alarmMessageList.size() > 0) {
                    allCallbacks.forEach(callback -> callback.doAlarm(alarmMessageList));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }
}

