/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.zookeeper;

import java.util.HashMap;
import java.util.Map;
import org.apache.jute.Record;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetChildren2Request;
import org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.GetMaxChildrenRequest;
import org.apache.zookeeper.proto.SetACLRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.proto.SetMaxChildrenRequest;
import org.apache.zookeeper.proto.SyncRequest;

class ZooOpt {
    private static final Map<Integer, String> OPTS = new HashMap<Integer, String>();
    private static final String PATH = "path";
    private static final String VERSION = "version";
    private static final String WATCH = "watch";
    private static final String MAX_CHILDREN = "max";
    private static final String KEEPER_STATE = "state";

    ZooOpt() {
    }

    static String getOperationName(Integer opCode) {
        String operationName = OPTS.get(opCode);
        return operationName == null ? "unknown" : operationName;
    }

    static void setTags(AbstractSpan span, Record record) {
        if (record instanceof CheckVersionRequest) {
            CheckVersionRequest recordImpl = (CheckVersionRequest)record;
            span.tag(PATH, recordImpl.getPath());
        } else if (record instanceof CreateRequest) {
            CreateRequest recordImpl = (CreateRequest)record;
            span.tag(PATH, recordImpl.getPath());
        } else if (record instanceof DeleteRequest) {
            DeleteRequest recordImpl = (DeleteRequest)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(VERSION, String.valueOf(recordImpl.getVersion()));
        } else if (record instanceof ExistsRequest) {
            ExistsRequest recordImpl = (ExistsRequest)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(WATCH, String.valueOf(recordImpl.getWatch()));
        } else if (record instanceof GetACLRequest) {
            GetACLRequest recordImpl = (GetACLRequest)record;
            span.tag(PATH, recordImpl.getPath());
        } else if (record instanceof GetChildren2Request) {
            GetChildren2Request recordImpl = (GetChildren2Request)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(WATCH, String.valueOf(recordImpl.getWatch()));
        } else if (record instanceof GetChildrenRequest) {
            GetChildrenRequest recordImpl = (GetChildrenRequest)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(WATCH, String.valueOf(recordImpl.getWatch()));
        } else if (record instanceof GetDataRequest) {
            GetDataRequest recordImpl = (GetDataRequest)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(WATCH, String.valueOf(recordImpl.getWatch()));
        } else if (record instanceof GetMaxChildrenRequest) {
            GetMaxChildrenRequest recordImpl = (GetMaxChildrenRequest)record;
            span.tag(PATH, recordImpl.getPath());
        } else if (record instanceof SetACLRequest) {
            SetACLRequest recordImpl = (SetACLRequest)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(VERSION, String.valueOf(recordImpl.getVersion()));
        } else if (record instanceof SetDataRequest) {
            SetDataRequest recordImpl = (SetDataRequest)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(VERSION, String.valueOf(recordImpl.getVersion()));
        } else if (record instanceof SetMaxChildrenRequest) {
            SetMaxChildrenRequest recordImpl = (SetMaxChildrenRequest)record;
            span.tag(PATH, recordImpl.getPath());
            span.tag(MAX_CHILDREN, String.valueOf(recordImpl.getMax()));
        } else if (record instanceof SyncRequest) {
            SyncRequest recordImpl = (SyncRequest)record;
            span.tag(PATH, recordImpl.getPath());
        }
    }

    static void setTags(AbstractSpan span, WatchedEvent event) {
        span.tag(PATH, event.getPath());
        span.tag(KEEPER_STATE, event.getState().name());
    }

    static {
        OPTS.put(0, "notification");
        OPTS.put(1, "create");
        OPTS.put(2, "delete");
        OPTS.put(3, "exists");
        OPTS.put(4, "getData");
        OPTS.put(5, "setData");
        OPTS.put(6, "getACL");
        OPTS.put(7, "setACL");
        OPTS.put(8, "getChildren");
        OPTS.put(9, "sync");
        OPTS.put(11, "ping");
        OPTS.put(12, "getChildren2");
        OPTS.put(13, "check");
        OPTS.put(14, "multi");
        OPTS.put(100, "auth");
        OPTS.put(101, "setWatches");
        OPTS.put(102, "sasl");
        OPTS.put(-10, "createSession");
        OPTS.put(-11, "closeSession");
        OPTS.put(-1, "error");
    }
}

