/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.zookeeper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.zookeeper.ZooOpt;
import org.apache.zookeeper.WatchedEvent;

public class EventThreadMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (this.isWatchedEvent(allArguments[0])) {
            Field field = allArguments[0].getClass().getDeclaredField("event");
            field.setAccessible(true);
            WatchedEvent event = (WatchedEvent)field.get(allArguments[0]);
            AbstractSpan span = ContextManager.createEntrySpan((String)("Zookeeper/WatchedEvent/" + event.getType().name()), null);
            ZooOpt.setTags(span, event);
            span.setComponent((Component)ComponentsDefine.ZOOKEEPER);
            Tags.DB_TYPE.set(span, "Zookeeper");
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (this.isWatchedEvent(allArguments[0])) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (this.isWatchedEvent(allArguments[0])) {
            ContextManager.activeSpan().errorOccurred().log(t);
        }
    }

    private boolean isWatchedEvent(Object event) {
        return event != null && "org.apache.zookeeper.ClientCnxn$WatcherSetEventPair".equals(event.getClass().getName());
    }
}

