/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.redisson.v3;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.connection.ConnectionManager;

public class ConnectionManagerInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final ILog logger = LogManager.getLogger(ConnectionManagerInterceptor.class);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        try {
            ConnectionManager connectionManager = (ConnectionManager)objInst;
            Config config = connectionManager.getCfg();
            SentinelServersConfig sentinelServersConfig = (SentinelServersConfig)this.getServersConfig(config, "sentinelServersConfig");
            MasterSlaveServersConfig masterSlaveServersConfig = (MasterSlaveServersConfig)this.getServersConfig(config, "masterSlaveServersConfig");
            ClusterServersConfig clusterServersConfig = (ClusterServersConfig)this.getServersConfig(config, "clusterServersConfig");
            ReplicatedServersConfig replicatedServersConfig = (ReplicatedServersConfig)this.getServersConfig(config, "replicatedServersConfig");
            StringBuilder peer = new StringBuilder();
            EnhancedInstance retInst = (EnhancedInstance)ret;
            if (sentinelServersConfig != null) {
                this.appendAddresses(peer, sentinelServersConfig.getSentinelAddresses());
                retInst.setSkyWalkingDynamicField((Object)peer.toString());
                return ret;
            }
            if (masterSlaveServersConfig != null) {
                URI masterAddress = masterSlaveServersConfig.getMasterAddress();
                peer.append(masterAddress.getHost()).append(":").append(masterAddress.getPort());
                this.appendAddresses(peer, masterSlaveServersConfig.getSlaveAddresses());
                retInst.setSkyWalkingDynamicField((Object)peer.toString());
                return ret;
            }
            if (clusterServersConfig != null) {
                this.appendAddresses(peer, clusterServersConfig.getNodeAddresses());
                retInst.setSkyWalkingDynamicField((Object)peer.toString());
                return ret;
            }
            if (replicatedServersConfig != null) {
                this.appendAddresses(peer, replicatedServersConfig.getNodeAddresses());
                retInst.setSkyWalkingDynamicField((Object)peer.toString());
                return ret;
            }
        }
        catch (Exception e) {
            logger.warn("redisClient set peer error: ", new Object[]{e});
        }
        return ret;
    }

    private Object getServersConfig(Config config, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = config.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(config);
    }

    private void appendAddresses(StringBuilder peer, Collection<URI> nodeAddresses) {
        if (nodeAddresses != null && !nodeAddresses.isEmpty()) {
            for (URI uri : nodeAddresses) {
                peer.append(uri.getHost()).append(":").append(uri.getPort()).append(";");
            }
        }
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

