/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.ref.Reference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.WeakEntry;
import org.apache.sis.util.resources.Errors;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private final ToIntFunction<Object> hashFunction;
    private final BiPredicate<Object, Object> comparator;
    private Entry[] table;
    private int count;
    private final Class<K> keyType;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient long lastTimeNormalCapacity;

    public WeakValueHashMap(Class<K> keyType) {
        this(keyType, false);
    }

    public WeakValueHashMap(Class<K> keyType, boolean identity) {
        this.keyType = Objects.requireNonNull(keyType);
        if (identity) {
            this.hashFunction = System::identityHashCode;
            this.comparator = WeakEntry::identityEqual;
        } else if (keyType.isArray()) {
            this.hashFunction = Utilities::deepHashCode;
            this.comparator = Objects::deepEquals;
        } else {
            this.hashFunction = Object::hashCode;
            this.comparator = Object::equals;
        }
        this.lastTimeNormalCapacity = System.nanoTime();
        this.table = new Entry[7];
    }

    public WeakValueHashMap(Class<K> keyType, ToIntFunction<Object> hashFunction, BiPredicate<Object, Object> comparator) {
        this.keyType = Objects.requireNonNull(keyType);
        this.hashFunction = Objects.requireNonNull(hashFunction);
        this.comparator = Objects.requireNonNull(comparator);
        this.lastTimeNormalCapacity = System.nanoTime();
        this.table = new Entry[7];
    }

    private synchronized void removeEntry(Entry toRemove) {
        assert (this.isValid());
        int capacity = this.table.length;
        if (toRemove.removeFrom(this.table, toRemove.hash % capacity)) {
            long currentTime;
            --this.count;
            assert (this.isValid());
            if (this.count < WeakEntry.lowerCapacityThreshold(capacity) && (currentTime = System.nanoTime()) - this.lastTimeNormalCapacity > 4000000000L) {
                this.table = (Entry[])WeakEntry.rehash(this.table, this.count, "remove");
                this.lastTimeNormalCapacity = currentTime;
                assert (this.isValid());
            }
        }
    }

    private boolean isValid() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.count > WeakEntry.upperCapacityThreshold(this.table.length)) {
            throw new AssertionError(this.count);
        }
        return WeakEntry.count(this.table) == this.count;
    }

    @Override
    public synchronized int size() {
        assert (this.isValid());
        return this.count;
    }

    private synchronized <R> R get(Object key, Function<Entry, R> getter, R defaultValue) {
        assert (this.isValid());
        if (key != null) {
            Entry[] table = this.table;
            int index = (this.hashFunction.applyAsInt(key) & Integer.MAX_VALUE) % table.length;
            Entry e = table[index];
            while (e != null) {
                if (this.comparator.test(key, e.key)) {
                    return getter.apply(e);
                }
                e = (Entry)e.next;
            }
        }
        return defaultValue;
    }

    public K intern(K key) {
        return (K)this.get(key, Entry::getKey, key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key, Function.identity(), null) != null;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.get(key, Reference::get, null);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.get(key, Reference::get, defaultValue);
    }

    private synchronized V intern(Object key, V value, Object condition) {
        assert (this.isValid());
        V oldValue = null;
        Entry[] table = this.table;
        int hash = this.hashFunction.applyAsInt(key) & Integer.MAX_VALUE;
        int index = hash % table.length;
        Entry e = table[index];
        while (e != null) {
            if (this.comparator.test(key, e.key)) {
                oldValue = (V)e.get();
                if (condition != null && !condition.equals(oldValue)) {
                    return oldValue;
                }
                e.dispose();
                table = this.table;
                index = hash % table.length;
            }
            e = (Entry)e.next;
        }
        if (value != null && (condition == null || condition == Wildcard.NO_VALUE || oldValue != null)) {
            if (++this.count >= WeakEntry.lowerCapacityThreshold(table.length)) {
                if (this.count > WeakEntry.upperCapacityThreshold(table.length)) {
                    this.table = table = (Entry[])WeakEntry.rehash(table, this.count, "put");
                    index = hash % table.length;
                }
                this.lastTimeNormalCapacity = System.nanoTime();
            }
            table[index] = new Entry(this.keyType.cast(key), value, table[index], hash);
        }
        assert (this.isValid());
        return oldValue;
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException(Errors.format(key == null ? (short)143 : 144));
        }
        return this.intern(key, value, null);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException(Errors.format(key == null ? (short)143 : 144));
        }
        return this.intern(key, value, Wildcard.NO_VALUE);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> creator) {
        V newValue;
        V value = this.get(key);
        if (value == null && (newValue = creator.apply(key)) != null && (value = this.putIfAbsent(key, newValue)) == null) {
            return newValue;
        }
        return value;
    }

    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new NullPointerException(Errors.format((short)144));
        }
        if (key == null) {
            return null;
        }
        return this.intern(key, value, Wildcard.ANY_VALUE);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (newValue == null) {
            throw new NullPointerException(Errors.format((short)144));
        }
        return this.replaceOrRemove(key, oldValue, newValue);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        return this.intern(key, null, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.replaceOrRemove(key, value, null);
    }

    private boolean replaceOrRemove(Object key, final Object oldValue, V newValue) {
        if (key == null || oldValue == null) {
            return false;
        }
        final class Observer {
            boolean equals;
            final /* synthetic */ WeakValueHashMap this$0;

            Observer() {
                this.this$0 = this$0;
            }

            public boolean equals(Object other) {
                this.equals = oldValue.equals(other);
                return this.equals;
            }
        }
        Observer observer = new Observer();
        return this.intern(key, newValue, observer) != null && observer.equals;
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private final class Entry
    extends WeakEntry<V>
    implements Map.Entry<K, V> {
        final K key;

        Entry(K key, V value, Entry next, int hash) {
            super(value, next, hash);
            this.key = key;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V value) {
            if (value != null) {
                throw new UnsupportedOperationException();
            }
            Object old = this.get();
            this.dispose();
            return old;
        }

        @Override
        public void dispose() {
            super.clear();
            WeakValueHashMap.this.removeEntry(this);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)other;
                return WeakValueHashMap.this.comparator.test(this.key, that.getKey()) && Objects.equals(this.get(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = WeakValueHashMap.this.hashFunction.applyAsInt(this.key);
            Object val = this.get();
            if (val != null) {
                code ^= val.hashCode();
            }
            return code;
        }
    }

    private static final class Wildcard {
        static final Wildcard ANY_VALUE = new Wildcard(true);
        static final Wildcard NO_VALUE = new Wildcard(false);
        private final boolean present;

        private Wildcard(boolean present) {
            this.present = present;
        }

        public boolean equals(Object oldValue) {
            return oldValue != null == this.present;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<K, V>[] toArray() {
            WeakValueHashMap weakValueHashMap = WeakValueHashMap.this;
            synchronized (weakValueHashMap) {
                Entry[] table;
                assert (WeakValueHashMap.this.isValid());
                Map.Entry[] elements = new Map.Entry[this.size()];
                int index = 0;
                for (Entry el : table = WeakValueHashMap.this.table) {
                    while (el != null) {
                        AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(el);
                        if (entry.getValue() != null) {
                            elements[index++] = entry;
                        }
                        el = (Entry)el.next;
                    }
                }
                return ArraysExt.resize(elements, index);
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Arrays.asList(this.toArray()).iterator();
        }
    }
}

