/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.test;

import java.lang.annotation.Documented;
import java.lang.annotation.Target;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;


/**
 * A test method producing an object to be used by another test method.
 *
 * <p>If this annotation was supported, we would annotate some methods with the {@code TestStep} annotation
 * instead of the JUnit {@link org.junit.Test} one. However, in current implementation, this functionality
 * is not supported and the test step methods must be explicitly invoked from another method. Consequently
 * this annotation is currently used only for documentation purpose, in case a future JUnit version would
 * support tests chaining.</p>
 *
 * @author  Martin Desruisseaux (Geomatys)
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
public @interface TestStep {
}
