/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AzimuthalEquidistant;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.internal.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class ModifiedAzimuthalEquidistant
extends AzimuthalEquidistant {
    private static final long serialVersionUID = 96569177715708509L;
    private final double \u212f2_\u03bd0_sin\u03c60;
    private final double G;
    private final double Hp;
    private final double Bp;

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.ModifiedAzimuthalEquidistant.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.ModifiedAzimuthalEquidistant.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.ModifiedAzimuthalEquidistant.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, null);
    }

    public ModifiedAzimuthalEquidistant(OperationMethod method, Parameters parameters) {
        this(ModifiedAzimuthalEquidistant.initializer(method, parameters));
    }

    private ModifiedAzimuthalEquidistant(Initializer initializer) {
        super(initializer);
        DoubleDouble \u03bd0 = initializer.r\u03bd2(this.sin\u03c60).sqrt().inverse();
        this.\u212f2_\u03bd0_sin\u03c60 = initializer.eccentricitySquared.multiply(\u03bd0).doubleValue() * this.sin\u03c60;
        double f = this.eccentricity / initializer.axisLengthRatio().doubleValue();
        this.G = f * this.sin\u03c60;
        this.Hp = f * this.cos\u03c60;
        this.Bp = 3.0 * this.eccentricitySquared * (this.sin\u03c60 * this.cos\u03c60) / (1.0 - this.eccentricitySquared);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(0, (Number)\u03bd0, null);
        denormalize.convertBefore(1, (Number)\u03bd0, null);
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        AzimuthalEquidistant kernel = this;
        if (this.eccentricity == 0.0) {
            kernel = new AzimuthalEquidistant(this);
        }
        return this.context.completeTransform(factory, kernel);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double c;
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03c6 = Math.sin(\u03c6);
        double r\u03bd = Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
        double tan\u03a8 = ((1.0 - this.eccentricitySquared) * sin\u03c6 + this.\u212f2_\u03bd0_sin\u03c60 * r\u03bd) / cos\u03c6;
        double rcos\u03a8 = Math.sqrt(1.0 + tan\u03a8 * tan\u03a8);
        double \u03b1 = Math.atan2(sin\u03bb, this.cos\u03c60 * tan\u03a8 - this.sin\u03c60 * cos\u03bb);
        double sin\u03b1 = Math.sin(\u03b1);
        double cos\u03b1 = Math.cos(\u03b1);
        double H = cos\u03b1 * this.Hp;
        if (Math.abs(sin\u03b1) < 1.5706706731410455E-9) {
            c = (this.cos\u03c60 * tan\u03a8 - this.sin\u03c60) / rcos\u03a8;
            if (cos\u03b1 < 0.0) {
                c = -c;
            }
        } else {
            c = sin\u03bb / (rcos\u03a8 * sin\u03b1);
        }
        c = Math.asin(c);
        double s2 = c * c;
        double s3 = s2 * c;
        double s4 = s2 * s2;
        double s5 = s4 * c;
        double H2 = H * H;
        double GH = this.G * H;
        c *= 1.0 - s2 / 6.0 * H2 * (1.0 - H2) + s3 / 8.0 * GH * (1.0 - 2.0 * H2) + s4 / 120.0 * (H2 * (4.0 - 7.0 * H2) - 3.0 * (this.G * this.G) * (1.0 - 7.0 * H2)) - s5 / 48.0 * GH;
        if (dstPts != null) {
            dstPts[dstOff] = c * sin\u03b1;
            dstPts[dstOff + 1] = c * cos\u03b1;
        }
        if (!derivate) {
            return null;
        }
        throw new ProjectionException("Derivative not yet implemented.");
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double D2 = x * x + y * y;
        double D = Math.sqrt(D2);
        double sin\u03b1 = 0.0;
        double cos\u03b1 = 0.0;
        if (D != 0.0) {
            sin\u03b1 = x / D;
            cos\u03b1 = y / D;
        }
        double negA = this.Hp * cos\u03b1;
        negA *= negA;
        double B = this.Bp * (1.0 + negA) * cos\u03b1;
        double J = D + negA * (1.0 - negA) * (D2 * D) / 6.0 - B * (1.0 - 3.0 * negA) * (D2 * D2) / 24.0;
        double J2 = J * J;
        double K = 1.0 + negA * J2 / 2.0 - B * (J2 * J) / 6.0;
        double sinJ = Math.sin(J);
        double sin\u03a8 = this.sin\u03c60 * Math.cos(J) + this.cos\u03c60 * sinJ * cos\u03b1;
        double cos\u03a8 = Math.sqrt(1.0 - sin\u03a8 * sin\u03a8);
        dstPts[dstOff] = Math.asin(sin\u03b1 * sinJ / cos\u03a8);
        dstPts[dstOff + 1] = Math.atan((1.0 - this.eccentricitySquared * this.sin\u03c60 * K / sin\u03a8) * (sin\u03a8 / cos\u03a8) / (1.0 - this.eccentricitySquared));
    }
}

