/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.xml.bind.referencing.CS_CoordinateSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.datum.EngineeringDatum;

@XmlType(name="EngineeringCRSType", propOrder={"abstractCS", "affineCS", "cartesianCS", "cylindricalCS", "linearCS", "polarCS", "sphericalCS", "userDefinedCS", "datum"})
@XmlRootElement(name="EngineeringCRS")
public class DefaultEngineeringCRS
extends AbstractCRS
implements EngineeringCRS {
    private static final long serialVersionUID = 6695541732063382701L;
    private EngineeringDatum datum;
    private static final Class<?>[] SPECIALIZED_TYPES = new Class[]{AffineCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, LinearCS.class, UserDefinedCS.class};

    public DefaultEngineeringCRS(Map<String, ?> properties, EngineeringDatum datum, CoordinateSystem cs) {
        super(properties, cs);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)datum);
        this.datum = datum;
    }

    protected DefaultEngineeringCRS(EngineeringCRS crs) {
        super((CoordinateReferenceSystem)crs);
        this.datum = crs.getDatum();
    }

    public static DefaultEngineeringCRS castOrCopy(EngineeringCRS object) {
        return object == null || object instanceof DefaultEngineeringCRS ? (DefaultEngineeringCRS)object : new DefaultEngineeringCRS(object);
    }

    public Class<? extends EngineeringCRS> getInterface() {
        return EngineeringCRS.class;
    }

    @XmlElement(name="engineeringDatum", required=true)
    public EngineeringDatum getDatum() {
        return this.datum;
    }

    @Override
    public DefaultEngineeringCRS forConvention(AxesConvention convention) {
        return (DefaultEngineeringCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultEngineeringCRS(properties, this.datum, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Local_CS" : (DefaultEngineeringCRS.isBaseCRS(formatter) ? "BaseEngCRS" : formatter.shortOrLong("EngCRS", "EngineeringCRS"));
    }

    private DefaultEngineeringCRS() {
    }

    private void setDatum(EngineeringDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultEngineeringCRS.class, (String)"setDatum", (String)"engineeringDatum");
        }
    }

    @XmlElement(name="affineCS")
    private AffineCS getAffineCS() {
        return this.getCoordinateSystem(AffineCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="cylindricalCS")
    private CylindricalCS getCylindricalCS() {
        return this.getCoordinateSystem(CylindricalCS.class);
    }

    @XmlElement(name="linearCS")
    private LinearCS getLinearCS() {
        return this.getCoordinateSystem(LinearCS.class);
    }

    @XmlElement(name="polarCS")
    private PolarCS getPolarCS() {
        return this.getCoordinateSystem(PolarCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    @XmlElement(name="userDefinedCS")
    private UserDefinedCS getUserDefinedCS() {
        return this.getCoordinateSystem(UserDefinedCS.class);
    }

    private void setAffineCS(AffineCS cs) {
        super.setCoordinateSystem("affineCS", (CoordinateSystem)cs);
    }

    private void setCartesianCS(CartesianCS cs) {
        super.setCoordinateSystem("cartesianCS", (CoordinateSystem)cs);
    }

    private void setCylindricalCS(CylindricalCS cs) {
        super.setCoordinateSystem("cylindricalCS", (CoordinateSystem)cs);
    }

    private void setLinearCS(LinearCS cs) {
        super.setCoordinateSystem("linearCS", (CoordinateSystem)cs);
    }

    private void setPolarCS(PolarCS cs) {
        super.setCoordinateSystem("polarCS", (CoordinateSystem)cs);
    }

    private void setSphericalCS(SphericalCS cs) {
        super.setCoordinateSystem("sphericalCS", (CoordinateSystem)cs);
    }

    private void setUserDefinedCS(UserDefinedCS cs) {
        super.setCoordinateSystem("userDefinedCS", (CoordinateSystem)cs);
    }

    @XmlElement(name="coordinateSystem", required=true)
    @XmlJavaTypeAdapter(value=CS_CoordinateSystem.class)
    private CoordinateSystem getAbstractCS() {
        CoordinateSystem cs = this.getCoordinateSystem();
        for (Class<?> t : SPECIALIZED_TYPES) {
            if (!t.isInstance(cs)) continue;
            return null;
        }
        return cs;
    }

    private void setAbstractCS(CoordinateSystem cs) {
        this.setCoordinateSystem(null, cs);
    }
}

