/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.FactoryException;

final class EllipsoidalHeightSeparator
implements AxisFilter {
    private final GeodeticDatum datum;
    private final boolean vertical;

    EllipsoidalHeightSeparator(GeodeticDatum datum, boolean vertical) {
        this.datum = datum;
        this.vertical = vertical;
    }

    @Override
    public boolean accept(CoordinateSystemAxis axis) {
        return AxisDirections.isVertical(axis.getDirection()) == this.vertical;
    }

    private static CRSFactory factory() {
        return GeodeticObjectFactory.provider();
    }

    SingleCRS separate(SingleCRS crs) throws FactoryException {
        CoordinateSystem cs = CoordinateSystems.replaceAxes(crs.getCoordinateSystem(), this);
        if (this.vertical) {
            VerticalCRS component = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!Utilities.equalsIgnoreMetadata((Object)component.getCoordinateSystem(), (Object)cs)) {
                component = EllipsoidalHeightSeparator.factory().createVerticalCRS(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)component), component.getDatum(), (VerticalCS)cs);
            }
            return component;
        }
        if (crs instanceof GeodeticCRS) {
            CommonCRS c;
            if (!(cs instanceof EllipsoidalCS)) {
                throw new IllegalArgumentException(Errors.format((short)178, (Object)IdentifiedObjects.getName((IdentifiedObject)cs, null)));
            }
            CommonCRS ref = CommonCRS.WGS84;
            if (Utilities.equalsIgnoreMetadata((Object)ref.geographic().getCoordinateSystem(), (Object)cs)) {
                CommonCRS c2 = CommonCRS.forDatum(this.datum);
                if (c2 != null) {
                    return c2.geographic();
                }
            } else if (Utilities.equalsIgnoreMetadata((Object)ref.normalizedGeographic().getCoordinateSystem(), (Object)cs) && (c = CommonCRS.forDatum(this.datum)) != null) {
                return c.normalizedGeographic();
            }
            return EllipsoidalHeightSeparator.factory().createGeographicCRS(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)crs), this.datum, (EllipsoidalCS)cs);
        }
        if (crs instanceof ProjectedCRS) {
            GeographicCRS baseCRS = ((ProjectedCRS)crs).getBaseCRS();
            if (ReferencingUtilities.getDimension((CoordinateReferenceSystem)baseCRS) != 2) {
                baseCRS = (GeographicCRS)this.separate((SingleCRS)baseCRS);
            }
            Object projection = ((ProjectedCRS)crs).getConversionFromBase();
            projection = new DefaultConversion(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)projection), projection.getMethod(), null, projection.getParameterValues());
            return EllipsoidalHeightSeparator.factory().createProjectedCRS(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)crs), baseCRS, (Conversion)projection, (CartesianCS)cs);
        }
        throw new IllegalArgumentException(Errors.format((short)163, crs.getClass()));
    }
}

